/*
 * This declarations of the PIC18F86K22 MCU.
 *
 * This file is part of the GNU PIC library for SDCC, originally
 * created by Molnar Karoly <molnarkaroly@users.sf.net> 2012.
 *
 * This file is generated automatically by the cinc2h.pl, 2012-11-01 17:31:23 UTC.
 *
 * SDCC is licensed under the GNU Public license (GPL) v2. Note that
 * this license covers the code to the compiler and other executables,
 * but explicitly does not cover any code or objects generated by sdcc.
 *
 * For pic device libraries and header files which are derived from
 * Microchip header (.inc) and linker script (.lkr) files Microchip
 * requires that "The header files should state that they are only to be
 * used with authentic Microchip devices" which makes them incompatible
 * with the GPL. Pic device libraries and header files are located at
 * non-free/lib and non-free/include directories respectively.
 * Sdcc should be run with the --use-non-free command line option in
 * order to include non-free header files and libraries.
 *
 * See http://sdcc.sourceforge.net/ for the latest information on sdcc.
 */

#ifndef __PIC18F86K22_H__
#define __PIC18F86K22_H__

//==============================================================================

//==============================================================================
//
//	Register Definitions
//
//==============================================================================


//==============================================================================
//        PMD3 Bits

extern __at(0x0F16) __sfr PMD3;

typedef struct
  {
  unsigned TMR12MD              : 1;
  unsigned CCP4MD               : 1;
  unsigned CCP5MD               : 1;
  unsigned CCP6MD               : 1;
  unsigned CCP7MD               : 1;
  unsigned CCP8MD               : 1;
  unsigned CCP9MD               : 1;
  unsigned CCP10MD              : 1;
  } __PMD3bits_t;

extern __at(0x0F16) volatile __PMD3bits_t PMD3bits;

#define _TMR12MD                0x01
#define _CCP4MD                 0x02
#define _CCP5MD                 0x04
#define _CCP6MD                 0x08
#define _CCP7MD                 0x10
#define _CCP8MD                 0x20
#define _CCP9MD                 0x40
#define _CCP10MD                0x80

//==============================================================================


//==============================================================================
//        PMD2 Bits

extern __at(0x0F17) __sfr PMD2;

typedef struct
  {
  unsigned CMP1MD               : 1;
  unsigned CMP2MD               : 1;
  unsigned CMP3MD               : 1;
  unsigned TMR5MD               : 1;
  unsigned TMR6MD               : 1;
  unsigned TMR7MD               : 1;
  unsigned TMR8MD               : 1;
  unsigned TMR10MD              : 1;
  } __PMD2bits_t;

extern __at(0x0F17) volatile __PMD2bits_t PMD2bits;

#define _CMP1MD                 0x01
#define _CMP2MD                 0x02
#define _CMP3MD                 0x04
#define _TMR5MD                 0x08
#define _TMR6MD                 0x10
#define _TMR7MD                 0x20
#define _TMR8MD                 0x40
#define _TMR10MD                0x80

//==============================================================================


//==============================================================================
//        PMD1 Bits

extern __at(0x0F18) __sfr PMD1;

typedef struct
  {
  unsigned EMBMD                : 1;
  unsigned TMR1MD               : 1;
  unsigned TMR2MD               : 1;
  unsigned TMR3MD               : 1;
  unsigned TMR4MD               : 1;
  unsigned RTCCMD               : 1;
  unsigned CTMUMD               : 1;
  unsigned PSPMD                : 1;
  } __PMD1bits_t;

extern __at(0x0F18) volatile __PMD1bits_t PMD1bits;

#define _EMBMD                  0x01
#define _TMR1MD                 0x02
#define _TMR2MD                 0x04
#define _TMR3MD                 0x08
#define _TMR4MD                 0x10
#define _RTCCMD                 0x20
#define _CTMUMD                 0x40
#define _PSPMD                  0x80

//==============================================================================


//==============================================================================
//        PMD0 Bits

extern __at(0x0F19) __sfr PMD0;

typedef struct
  {
  unsigned ADCMD                : 1;
  unsigned SSP1MD               : 1;
  unsigned SSP2MD               : 1;
  unsigned UART1MD              : 1;
  unsigned UART2MD              : 1;
  unsigned CCP1MD               : 1;
  unsigned CCP2MD               : 1;
  unsigned CCP3MD               : 1;
  } __PMD0bits_t;

extern __at(0x0F19) volatile __PMD0bits_t PMD0bits;

#define _ADCMD                  0x01
#define _SSP1MD                 0x02
#define _SSP2MD                 0x04
#define _UART1MD                0x08
#define _UART2MD                0x10
#define _CCP1MD                 0x20
#define _CCP2MD                 0x40
#define _CCP3MD                 0x80

//==============================================================================


//==============================================================================
//        PSTR3CON Bits

extern __at(0x0F1A) __sfr PSTR3CON;

typedef union
  {
  struct
    {
    unsigned STRA               : 1;
    unsigned STRB               : 1;
    unsigned STRC               : 1;
    unsigned STRD               : 1;
    unsigned STRSYNC            : 1;
    unsigned                    : 1;
    unsigned CMPL0              : 1;
    unsigned CMPL1              : 1;
    };

  struct
    {
    unsigned                    : 6;
    unsigned CMPL               : 2;
    };
  } __PSTR3CONbits_t;

extern __at(0x0F1A) volatile __PSTR3CONbits_t PSTR3CONbits;

#define _PSTR3CON_STRA          0x01
#define _PSTR3CON_STRB          0x02
#define _PSTR3CON_STRC          0x04
#define _PSTR3CON_STRD          0x08
#define _PSTR3CON_STRSYNC       0x10
#define _PSTR3CON_CMPL0         0x40
#define _PSTR3CON_CMPL1         0x80

//==============================================================================


//==============================================================================
//        PSTR2CON Bits

extern __at(0x0F1B) __sfr PSTR2CON;

typedef union
  {
  struct
    {
    unsigned STRA               : 1;
    unsigned STRB               : 1;
    unsigned STRC               : 1;
    unsigned STRD               : 1;
    unsigned STRSYNC            : 1;
    unsigned                    : 1;
    unsigned CMPL0              : 1;
    unsigned CMPL1              : 1;
    };

  struct
    {
    unsigned                    : 6;
    unsigned CMPL               : 2;
    };
  } __PSTR2CONbits_t;

extern __at(0x0F1B) volatile __PSTR2CONbits_t PSTR2CONbits;

#define _PSTR2CON_STRA          0x01
#define _PSTR2CON_STRB          0x02
#define _PSTR2CON_STRC          0x04
#define _PSTR2CON_STRD          0x08
#define _PSTR2CON_STRSYNC       0x10
#define _PSTR2CON_CMPL0         0x40
#define _PSTR2CON_CMPL1         0x80

//==============================================================================

extern __at(0x0F1C) __sfr TXREG2;
extern __at(0x0F1D) __sfr RCREG2;
extern __at(0x0F1E) __sfr SPBRG2;
extern __at(0x0F1F) __sfr SPBRGH2;

//==============================================================================
//        BAUDCON2 Bits

extern __at(0x0F20) __sfr BAUDCON2;

typedef struct
  {
  unsigned ABDEN                : 1;
  unsigned WUE                  : 1;
  unsigned                      : 1;
  unsigned BRG16                : 1;
  unsigned TXCKP                : 1;
  unsigned RXDTP                : 1;
  unsigned RCIDL                : 1;
  unsigned ABDOVF               : 1;
  } __BAUDCON2bits_t;

extern __at(0x0F20) volatile __BAUDCON2bits_t BAUDCON2bits;

#define _BAUDCON2_ABDEN         0x01
#define _BAUDCON2_WUE           0x02
#define _BAUDCON2_BRG16         0x08
#define _BAUDCON2_TXCKP         0x10
#define _BAUDCON2_RXDTP         0x20
#define _BAUDCON2_RCIDL         0x40
#define _BAUDCON2_ABDOVF        0x80

//==============================================================================


//==============================================================================
//        TXSTA2 Bits

extern __at(0x0F21) __sfr TXSTA2;

typedef union
  {
  struct
    {
    unsigned TX9D               : 1;
    unsigned TRMT               : 1;
    unsigned BRGH               : 1;
    unsigned SENDB              : 1;
    unsigned SYNC               : 1;
    unsigned TXEN               : 1;
    unsigned TX9                : 1;
    unsigned CSRC               : 1;
    };

  struct
    {
    unsigned TX9D2              : 1;
    unsigned TRMT2              : 1;
    unsigned BRGH2              : 1;
    unsigned SENDB2             : 1;
    unsigned SYNC2              : 1;
    unsigned TXEN2              : 1;
    unsigned TX92               : 1;
    unsigned CSRC2              : 1;
    };
  } __TXSTA2bits_t;

extern __at(0x0F21) volatile __TXSTA2bits_t TXSTA2bits;

#define _TXSTA2_TX9D            0x01
#define _TXSTA2_TX9D2           0x01
#define _TXSTA2_TRMT            0x02
#define _TXSTA2_TRMT2           0x02
#define _TXSTA2_BRGH            0x04
#define _TXSTA2_BRGH2           0x04
#define _TXSTA2_SENDB           0x08
#define _TXSTA2_SENDB2          0x08
#define _TXSTA2_SYNC            0x10
#define _TXSTA2_SYNC2           0x10
#define _TXSTA2_TXEN            0x20
#define _TXSTA2_TXEN2           0x20
#define _TXSTA2_TX9             0x40
#define _TXSTA2_TX92            0x40
#define _TXSTA2_CSRC            0x80
#define _TXSTA2_CSRC2           0x80

//==============================================================================


//==============================================================================
//        RCSTA2 Bits

extern __at(0x0F22) __sfr RCSTA2;

typedef union
  {
  struct
    {
    unsigned RX9D               : 1;
    unsigned OERR               : 1;
    unsigned FERR               : 1;
    unsigned ADDEN              : 1;
    unsigned CREN               : 1;
    unsigned SREN               : 1;
    unsigned RX9                : 1;
    unsigned SPEN               : 1;
    };

  struct
    {
    unsigned RX9D2              : 1;
    unsigned OERR2              : 1;
    unsigned FERR2              : 1;
    unsigned ADDEN2             : 1;
    unsigned CREN2              : 1;
    unsigned SREN2              : 1;
    unsigned RX92               : 1;
    unsigned SPEN2              : 1;
    };
  } __RCSTA2bits_t;

extern __at(0x0F22) volatile __RCSTA2bits_t RCSTA2bits;

#define _RCSTA2_RX9D            0x01
#define _RCSTA2_RX9D2           0x01
#define _RCSTA2_OERR            0x02
#define _RCSTA2_OERR2           0x02
#define _RCSTA2_FERR            0x04
#define _RCSTA2_FERR2           0x04
#define _RCSTA2_ADDEN           0x08
#define _RCSTA2_ADDEN2          0x08
#define _RCSTA2_CREN            0x10
#define _RCSTA2_CREN2           0x10
#define _RCSTA2_SREN            0x20
#define _RCSTA2_SREN2           0x20
#define _RCSTA2_RX9             0x40
#define _RCSTA2_RX92            0x40
#define _RCSTA2_SPEN            0x80
#define _RCSTA2_SPEN2           0x80

//==============================================================================


//==============================================================================
//        ANCON2 Bits

extern __at(0x0F23) __sfr ANCON2;

typedef struct
  {
  unsigned ANSEL16              : 1;
  unsigned ANSEL17              : 1;
  unsigned ANSEL18              : 1;
  unsigned ANSEL19              : 1;
  unsigned ANSEL20              : 1;
  unsigned ANSEL21              : 1;
  unsigned ANSEL22              : 1;
  unsigned ANSEL23              : 1;
  } __ANCON2bits_t;

extern __at(0x0F23) volatile __ANCON2bits_t ANCON2bits;

#define _ANSEL16                0x01
#define _ANSEL17                0x02
#define _ANSEL18                0x04
#define _ANSEL19                0x08
#define _ANSEL20                0x10
#define _ANSEL21                0x20
#define _ANSEL22                0x40
#define _ANSEL23                0x80

//==============================================================================


//==============================================================================
//        ANCON1 Bits

extern __at(0x0F24) __sfr ANCON1;

typedef struct
  {
  unsigned ANSEL8               : 1;
  unsigned ANSEL9               : 1;
  unsigned ANSEL10              : 1;
  unsigned ANSEL11              : 1;
  unsigned ANSEL12              : 1;
  unsigned ANSEL13              : 1;
  unsigned ANSEL14              : 1;
  unsigned ANSEL15              : 1;
  } __ANCON1bits_t;

extern __at(0x0F24) volatile __ANCON1bits_t ANCON1bits;

#define _ANSEL8                 0x01
#define _ANSEL9                 0x02
#define _ANSEL10                0x04
#define _ANSEL11                0x08
#define _ANSEL12                0x10
#define _ANSEL13                0x20
#define _ANSEL14                0x40
#define _ANSEL15                0x80

//==============================================================================


//==============================================================================
//        ANCON0 Bits

extern __at(0x0F25) __sfr ANCON0;

typedef struct
  {
  unsigned ANSEL0               : 1;
  unsigned ANSEL1               : 1;
  unsigned ANSEL2               : 1;
  unsigned ANSEL3               : 1;
  unsigned ANSEL4               : 1;
  unsigned ANSEL5               : 1;
  unsigned ANSEL6               : 1;
  unsigned ANSEL7               : 1;
  } __ANCON0bits_t;

extern __at(0x0F25) volatile __ANCON0bits_t ANCON0bits;

#define _ANSEL0                 0x01
#define _ANSEL1                 0x02
#define _ANSEL2                 0x04
#define _ANSEL3                 0x08
#define _ANSEL4                 0x10
#define _ANSEL5                 0x20
#define _ANSEL6                 0x40
#define _ANSEL7                 0x80

//==============================================================================


//==============================================================================
//        MEMCON Bits

extern __at(0x0F26) __sfr MEMCON;

typedef union
  {
  struct
    {
    unsigned WM0                : 1;
    unsigned WM1                : 1;
    unsigned                    : 1;
    unsigned                    : 1;
    unsigned WAIT0              : 1;
    unsigned WAIT1              : 1;
    unsigned                    : 1;
    unsigned EBDIS              : 1;
    };

  struct
    {
    unsigned WM                 : 2;
    unsigned                    : 6;
    };

  struct
    {
    unsigned                    : 4;
    unsigned WAIT               : 2;
    unsigned                    : 2;
    };
  } __MEMCONbits_t;

extern __at(0x0F26) volatile __MEMCONbits_t MEMCONbits;

#define _WM0                    0x01
#define _WM1                    0x02
#define _WAIT0                  0x10
#define _WAIT1                  0x20
#define _EBDIS                  0x80

//==============================================================================


//==============================================================================
//        ODCON3 Bits

extern __at(0x0F27) __sfr ODCON3;

typedef struct
  {
  unsigned CTMUDS               : 1;
  unsigned                      : 1;
  unsigned                      : 1;
  unsigned                      : 1;
  unsigned                      : 1;
  unsigned                      : 1;
  unsigned U1OD                 : 1;
  unsigned U2OD                 : 1;
  } __ODCON3bits_t;

extern __at(0x0F27) volatile __ODCON3bits_t ODCON3bits;

#define _CTMUDS                 0x01
#define _U1OD                   0x40
#define _U2OD                   0x80

//==============================================================================


//==============================================================================
//        ODCON2 Bits

extern __at(0x0F28) __sfr ODCON2;

typedef struct
  {
  unsigned CCP3OD               : 1;
  unsigned CCP4OD               : 1;
  unsigned CCP5OD               : 1;
  unsigned CCP6OD               : 1;
  unsigned CCP7OD               : 1;
  unsigned CCP8OD               : 1;
  unsigned CCP9OD               : 1;
  unsigned CCP10OD              : 1;
  } __ODCON2bits_t;

extern __at(0x0F28) volatile __ODCON2bits_t ODCON2bits;

#define _CCP3OD                 0x01
#define _CCP4OD                 0x02
#define _CCP5OD                 0x04
#define _CCP6OD                 0x08
#define _CCP7OD                 0x10
#define _CCP8OD                 0x20
#define _CCP9OD                 0x40
#define _CCP10OD                0x80

//==============================================================================


//==============================================================================
//        ODCON1 Bits

extern __at(0x0F29) __sfr ODCON1;

typedef struct
  {
  unsigned SPI2OD               : 1;
  unsigned                      : 1;
  unsigned                      : 1;
  unsigned                      : 1;
  unsigned                      : 1;
  unsigned CCP1OD               : 1;
  unsigned CCP2OD               : 1;
  unsigned SPI1OD               : 1;
  } __ODCON1bits_t;

extern __at(0x0F29) volatile __ODCON1bits_t ODCON1bits;

#define _SPI2OD                 0x01
#define _CCP1OD                 0x20
#define _CCP2OD                 0x40
#define _SPI1OD                 0x80

//==============================================================================


//==============================================================================
//        REFOCON Bits

extern __at(0x0F2A) __sfr REFOCON;

typedef union
  {
  struct
    {
    unsigned RODIV0             : 1;
    unsigned RODIV1             : 1;
    unsigned RODIV2             : 1;
    unsigned RODIV3             : 1;
    unsigned ROSEL              : 1;
    unsigned ROSSLP             : 1;
    unsigned                    : 1;
    unsigned ROON               : 1;
    };

  struct
    {
    unsigned RODIV              : 4;
    unsigned                    : 4;
    };
  } __REFOCONbits_t;

extern __at(0x0F2A) volatile __REFOCONbits_t REFOCONbits;

#define _RODIV0                 0x01
#define _RODIV1                 0x02
#define _RODIV2                 0x04
#define _RODIV3                 0x08
#define _ROSEL                  0x10
#define _ROSSLP                 0x20
#define _ROON                   0x80

//==============================================================================


//==============================================================================
//        CCPTMRS2 Bits

extern __at(0x0F2B) __sfr CCPTMRS2;

typedef union
  {
  struct
    {
    unsigned C8TSEL0            : 1;
    unsigned C8TSEL1            : 1;
    unsigned C9TSEL0            : 1;
    unsigned                    : 1;
    unsigned C10TSEL0           : 1;
    unsigned                    : 1;
    unsigned                    : 1;
    unsigned                    : 1;
    };

  struct
    {
    unsigned C8TSEL             : 2;
    unsigned                    : 6;
    };
  } __CCPTMRS2bits_t;

extern __at(0x0F2B) volatile __CCPTMRS2bits_t CCPTMRS2bits;

#define _C8TSEL0                0x01
#define _C8TSEL1                0x02
#define _C9TSEL0                0x04
#define _C10TSEL0               0x10

//==============================================================================


//==============================================================================
//        CCPTMRS1 Bits

extern __at(0x0F2C) __sfr CCPTMRS1;

typedef union
  {
  struct
    {
    unsigned C4TSEL0            : 1;
    unsigned C4TSEL1            : 1;
    unsigned C5TSEL0            : 1;
    unsigned                    : 1;
    unsigned C6TSEL0            : 1;
    unsigned                    : 1;
    unsigned C7TSEL0            : 1;
    unsigned C7TSEL1            : 1;
    };

  struct
    {
    unsigned C4TSEL             : 2;
    unsigned                    : 6;
    };

  struct
    {
    unsigned                    : 6;
    unsigned C7TSEL             : 2;
    };
  } __CCPTMRS1bits_t;

extern __at(0x0F2C) volatile __CCPTMRS1bits_t CCPTMRS1bits;

#define _C4TSEL0                0x01
#define _C4TSEL1                0x02
#define _C5TSEL0                0x04
#define _C6TSEL0                0x10
#define _C7TSEL0                0x40
#define _C7TSEL1                0x80

//==============================================================================


//==============================================================================
//        CCPTMRS0 Bits

extern __at(0x0F2D) __sfr CCPTMRS0;

typedef union
  {
  struct
    {
    unsigned C1TSEL0            : 1;
    unsigned C1TSEL1            : 1;
    unsigned C1TSEL2            : 1;
    unsigned C2TSEL0            : 1;
    unsigned C2TSEL1            : 1;
    unsigned C2TSEL2            : 1;
    unsigned C3TSEL0            : 1;
    unsigned C3TSEL1            : 1;
    };

  struct
    {
    unsigned C1TSEL             : 3;
    unsigned                    : 5;
    };

  struct
    {
    unsigned                    : 3;
    unsigned C2TSEL             : 3;
    unsigned                    : 2;
    };

  struct
    {
    unsigned                    : 6;
    unsigned C3TSEL             : 2;
    };
  } __CCPTMRS0bits_t;

extern __at(0x0F2D) volatile __CCPTMRS0bits_t CCPTMRS0bits;

#define _C1TSEL0                0x01
#define _C1TSEL1                0x02
#define _C1TSEL2                0x04
#define _C2TSEL0                0x08
#define _C2TSEL1                0x10
#define _C2TSEL2                0x20
#define _C3TSEL0                0x40
#define _C3TSEL1                0x80

//==============================================================================


//==============================================================================
//        CM3CON Bits

extern __at(0x0F2E) __sfr CM3CON;

typedef union
  {
  struct
    {
    unsigned CCH0               : 1;
    unsigned CCH1               : 1;
    unsigned CREF               : 1;
    unsigned EVPOL0             : 1;
    unsigned EVPOL1             : 1;
    unsigned CPOL               : 1;
    unsigned COE                : 1;
    unsigned CON                : 1;
    };

  struct
    {
    unsigned CCH                : 2;
    unsigned                    : 6;
    };

  struct
    {
    unsigned                    : 3;
    unsigned EVPOL              : 2;
    unsigned                    : 3;
    };
  } __CM3CONbits_t;

extern __at(0x0F2E) volatile __CM3CONbits_t CM3CONbits;

#define _CM3CON_CCH0            0x01
#define _CM3CON_CCH1            0x02
#define _CM3CON_CREF            0x04
#define _CM3CON_EVPOL0          0x08
#define _CM3CON_EVPOL1          0x10
#define _CM3CON_CPOL            0x20
#define _CM3CON_COE             0x40
#define _CM3CON_CON             0x80

//==============================================================================


//==============================================================================
//        CM3CON1 Bits

extern __at(0x0F2E) __sfr CM3CON1;

typedef union
  {
  struct
    {
    unsigned CCH0               : 1;
    unsigned CCH1               : 1;
    unsigned CREF               : 1;
    unsigned EVPOL0             : 1;
    unsigned EVPOL1             : 1;
    unsigned CPOL               : 1;
    unsigned COE                : 1;
    unsigned CON                : 1;
    };

  struct
    {
    unsigned CCH                : 2;
    unsigned                    : 6;
    };

  struct
    {
    unsigned                    : 3;
    unsigned EVPOL              : 2;
    unsigned                    : 3;
    };
  } __CM3CON1bits_t;

extern __at(0x0F2E) volatile __CM3CON1bits_t CM3CON1bits;

#define _CM3CON1_CCH0           0x01
#define _CM3CON1_CCH1           0x02
#define _CM3CON1_CREF           0x04
#define _CM3CON1_EVPOL0         0x08
#define _CM3CON1_EVPOL1         0x10
#define _CM3CON1_CPOL           0x20
#define _CM3CON1_COE            0x40
#define _CM3CON1_CON            0x80

//==============================================================================


//==============================================================================
//        CM2CON Bits

extern __at(0x0F2F) __sfr CM2CON;

typedef union
  {
  struct
    {
    unsigned CCH0               : 1;
    unsigned CCH1               : 1;
    unsigned CREF               : 1;
    unsigned EVPOL0             : 1;
    unsigned EVPOL1             : 1;
    unsigned CPOL               : 1;
    unsigned COE                : 1;
    unsigned CON                : 1;
    };

  struct
    {
    unsigned CCH                : 2;
    unsigned                    : 6;
    };

  struct
    {
    unsigned                    : 3;
    unsigned EVPOL              : 2;
    unsigned                    : 3;
    };
  } __CM2CONbits_t;

extern __at(0x0F2F) volatile __CM2CONbits_t CM2CONbits;

#define _CM2CON_CCH0            0x01
#define _CM2CON_CCH1            0x02
#define _CM2CON_CREF            0x04
#define _CM2CON_EVPOL0          0x08
#define _CM2CON_EVPOL1          0x10
#define _CM2CON_CPOL            0x20
#define _CM2CON_COE             0x40
#define _CM2CON_CON             0x80

//==============================================================================


//==============================================================================
//        CM2CON1 Bits

extern __at(0x0F2F) __sfr CM2CON1;

typedef union
  {
  struct
    {
    unsigned CCH0               : 1;
    unsigned CCH1               : 1;
    unsigned CREF               : 1;
    unsigned EVPOL0             : 1;
    unsigned EVPOL1             : 1;
    unsigned CPOL               : 1;
    unsigned COE                : 1;
    unsigned CON                : 1;
    };

  struct
    {
    unsigned CCH                : 2;
    unsigned                    : 6;
    };

  struct
    {
    unsigned                    : 3;
    unsigned EVPOL              : 2;
    unsigned                    : 3;
    };
  } __CM2CON1bits_t;

extern __at(0x0F2F) volatile __CM2CON1bits_t CM2CON1bits;

#define _CM2CON1_CCH0           0x01
#define _CM2CON1_CCH1           0x02
#define _CM2CON1_CREF           0x04
#define _CM2CON1_EVPOL0         0x08
#define _CM2CON1_EVPOL1         0x10
#define _CM2CON1_CPOL           0x20
#define _CM2CON1_COE            0x40
#define _CM2CON1_CON            0x80

//==============================================================================


//==============================================================================
//        T12CON Bits

extern __at(0x0F30) __sfr T12CON;

typedef union
  {
  struct
    {
    unsigned T12CKPS0           : 1;
    unsigned T12CKPS1           : 1;
    unsigned TMR12ON            : 1;
    unsigned T12OUTPS0          : 1;
    unsigned T12OUTPS1          : 1;
    unsigned T12OUTPS2          : 1;
    unsigned T12OUTPS3          : 1;
    unsigned                    : 1;
    };

  struct
    {
    unsigned T12CKPS            : 2;
    unsigned                    : 6;
    };

  struct
    {
    unsigned                    : 3;
    unsigned T12OUTPS           : 4;
    unsigned                    : 1;
    };
  } __T12CONbits_t;

extern __at(0x0F30) volatile __T12CONbits_t T12CONbits;

#define _T12CKPS0               0x01
#define _T12CKPS1               0x02
#define _TMR12ON                0x04
#define _T12OUTPS0              0x08
#define _T12OUTPS1              0x10
#define _T12OUTPS2              0x20
#define _T12OUTPS3              0x40

//==============================================================================

extern __at(0x0F31) __sfr PR12;
extern __at(0x0F32) __sfr TMR12;

//==============================================================================
//        T10CON Bits

extern __at(0x0F33) __sfr T10CON;

typedef union
  {
  struct
    {
    unsigned T10CKPS0           : 1;
    unsigned T10CKPS1           : 1;
    unsigned TMR10ON            : 1;
    unsigned T10OUTPS0          : 1;
    unsigned T10OUTPS1          : 1;
    unsigned T10OUTPS2          : 1;
    unsigned T10OUTPS3          : 1;
    unsigned                    : 1;
    };

  struct
    {
    unsigned T10CKPS            : 2;
    unsigned                    : 6;
    };

  struct
    {
    unsigned                    : 3;
    unsigned T10OUTPS           : 4;
    unsigned                    : 1;
    };
  } __T10CONbits_t;

extern __at(0x0F33) volatile __T10CONbits_t T10CONbits;

#define _T10CKPS0               0x01
#define _T10CKPS1               0x02
#define _TMR10ON                0x04
#define _T10OUTPS0              0x08
#define _T10OUTPS1              0x10
#define _T10OUTPS2              0x20
#define _T10OUTPS3              0x40

//==============================================================================

extern __at(0x0F34) __sfr PR10;
extern __at(0x0F35) __sfr TMR10;

//==============================================================================
//        T8CON Bits

extern __at(0x0F36) __sfr T8CON;

typedef union
  {
  struct
    {
    unsigned T8CKPS0            : 1;
    unsigned T8CKPS1            : 1;
    unsigned TMR8ON             : 1;
    unsigned T8OUTPS0           : 1;
    unsigned T8OUTPS1           : 1;
    unsigned T8OUTPS2           : 1;
    unsigned T8OUTPS3           : 1;
    unsigned                    : 1;
    };

  struct
    {
    unsigned T8CKPS             : 2;
    unsigned                    : 6;
    };

  struct
    {
    unsigned                    : 3;
    unsigned T8OUTPS            : 4;
    unsigned                    : 1;
    };
  } __T8CONbits_t;

extern __at(0x0F36) volatile __T8CONbits_t T8CONbits;

#define _T8CKPS0                0x01
#define _T8CKPS1                0x02
#define _TMR8ON                 0x04
#define _T8OUTPS0               0x08
#define _T8OUTPS1               0x10
#define _T8OUTPS2               0x20
#define _T8OUTPS3               0x40

//==============================================================================

extern __at(0x0F37) __sfr PR8;
extern __at(0x0F38) __sfr TMR8;

//==============================================================================
//        T6CON Bits

extern __at(0x0F39) __sfr T6CON;

typedef union
  {
  struct
    {
    unsigned T6CKPS0            : 1;
    unsigned T6CKPS1            : 1;
    unsigned TMR6ON             : 1;
    unsigned T6OUTPS0           : 1;
    unsigned T6OUTPS1           : 1;
    unsigned T6OUTPS2           : 1;
    unsigned T6OUTPS3           : 1;
    unsigned                    : 1;
    };

  struct
    {
    unsigned T6CKPS             : 2;
    unsigned                    : 6;
    };

  struct
    {
    unsigned                    : 3;
    unsigned T6OUTPS            : 4;
    unsigned                    : 1;
    };
  } __T6CONbits_t;

extern __at(0x0F39) volatile __T6CONbits_t T6CONbits;

#define _T6CKPS0                0x01
#define _T6CKPS1                0x02
#define _TMR6ON                 0x04
#define _T6OUTPS0               0x08
#define _T6OUTPS1               0x10
#define _T6OUTPS2               0x20
#define _T6OUTPS3               0x40

//==============================================================================

extern __at(0x0F3A) __sfr PR6;
extern __at(0x0F3B) __sfr TMR6;

//==============================================================================
//        T7GCON Bits

extern __at(0x0F3C) __sfr T7GCON;

typedef union
  {
  struct
    {
    unsigned T7GSS0             : 1;
    unsigned T7GSS1             : 1;
    unsigned T7GVAL             : 1;
    unsigned T7GGO_NOT_T7DONE   : 1;
    unsigned T7GSPM             : 1;
    unsigned T7GTM              : 1;
    unsigned T7GPOL             : 1;
    unsigned TMR7GE             : 1;
    };

  struct
    {
    unsigned                    : 1;
    unsigned                    : 1;
    unsigned                    : 1;
    unsigned T7GGO              : 1;
    unsigned                    : 1;
    unsigned                    : 1;
    unsigned                    : 1;
    unsigned                    : 1;
    };

  struct
    {
    unsigned                    : 1;
    unsigned                    : 1;
    unsigned                    : 1;
    unsigned NOT_T7DONE         : 1;
    unsigned                    : 1;
    unsigned                    : 1;
    unsigned                    : 1;
    unsigned                    : 1;
    };

  struct
    {
    unsigned T7GSS              : 2;
    unsigned                    : 6;
    };
  } __T7GCONbits_t;

extern __at(0x0F3C) volatile __T7GCONbits_t T7GCONbits;

#define _T7GSS0                 0x01
#define _T7GSS1                 0x02
#define _T7GVAL                 0x04
#define _T7GGO_NOT_T7DONE       0x08
#define _T7GGO                  0x08
#define _NOT_T7DONE             0x08
#define _T7GSPM                 0x10
#define _T7GTM                  0x20
#define _T7GPOL                 0x40
#define _TMR7GE                 0x80

//==============================================================================


//==============================================================================
//        T7CON Bits

extern __at(0x0F3D) __sfr T7CON;

typedef union
  {
  struct
    {
    unsigned TMR7ON             : 1;
    unsigned RD16               : 1;
    unsigned NOT_T7SYNC         : 1;
    unsigned SOSCEN             : 1;
    unsigned T7CKPS0            : 1;
    unsigned T7CKPS1            : 1;
    unsigned TMR7CS0            : 1;
    unsigned TMR7CS1            : 1;
    };

  struct
    {
    unsigned                    : 4;
    unsigned T7CKPS             : 2;
    unsigned                    : 2;
    };

  struct
    {
    unsigned                    : 6;
    unsigned TMR7CS             : 2;
    };
  } __T7CONbits_t;

extern __at(0x0F3D) volatile __T7CONbits_t T7CONbits;

#define _T7CON_TMR7ON           0x01
#define _T7CON_RD16             0x02
#define _T7CON_NOT_T7SYNC       0x04
#define _T7CON_SOSCEN           0x08
#define _T7CON_T7CKPS0          0x10
#define _T7CON_T7CKPS1          0x20
#define _T7CON_TMR7CS0          0x40
#define _T7CON_TMR7CS1          0x80

//==============================================================================

extern __at(0x0F3E) __sfr TMR7;
extern __at(0x0F3E) __sfr TMR7L;
extern __at(0x0F3F) __sfr TMR7H;

//==============================================================================
//        CCP10CON Bits

extern __at(0x0F40) __sfr CCP10CON;

typedef union
  {
  struct
    {
    unsigned CCP10M0            : 1;
    unsigned CCP10M1            : 1;
    unsigned CCP10M2            : 1;
    unsigned CCP10M3            : 1;
    unsigned DC10B0             : 1;
    unsigned DC10B1             : 1;
    unsigned                    : 1;
    unsigned                    : 1;
    };

  struct
    {
    unsigned                    : 1;
    unsigned                    : 1;
    unsigned                    : 1;
    unsigned                    : 1;
    unsigned CCP10Y             : 1;
    unsigned CCP10X             : 1;
    unsigned                    : 1;
    unsigned                    : 1;
    };

  struct
    {
    unsigned CCP10M             : 4;
    unsigned                    : 4;
    };

  struct
    {
    unsigned                    : 4;
    unsigned DC10B              : 2;
    unsigned                    : 2;
    };
  } __CCP10CONbits_t;

extern __at(0x0F40) volatile __CCP10CONbits_t CCP10CONbits;

#define _CCP10M0                0x01
#define _CCP10M1                0x02
#define _CCP10M2                0x04
#define _CCP10M3                0x08
#define _DC10B0                 0x10
#define _CCP10Y                 0x10
#define _DC10B1                 0x20
#define _CCP10X                 0x20

//==============================================================================

extern __at(0x0F41) __sfr CCPR10;
extern __at(0x0F41) __sfr CCPR10L;
extern __at(0x0F42) __sfr CCPR10H;

//==============================================================================
//        CCP9CON Bits

extern __at(0x0F43) __sfr CCP9CON;

typedef union
  {
  struct
    {
    unsigned CCP9M0             : 1;
    unsigned CCP9M1             : 1;
    unsigned CCP9M2             : 1;
    unsigned CCP9M3             : 1;
    unsigned DC9B0              : 1;
    unsigned DC9B1              : 1;
    unsigned                    : 1;
    unsigned                    : 1;
    };

  struct
    {
    unsigned                    : 1;
    unsigned                    : 1;
    unsigned                    : 1;
    unsigned                    : 1;
    unsigned CCP9Y              : 1;
    unsigned CCP9X              : 1;
    unsigned                    : 1;
    unsigned                    : 1;
    };

  struct
    {
    unsigned CCP9M              : 4;
    unsigned                    : 4;
    };

  struct
    {
    unsigned                    : 4;
    unsigned DC9B               : 2;
    unsigned                    : 2;
    };
  } __CCP9CONbits_t;

extern __at(0x0F43) volatile __CCP9CONbits_t CCP9CONbits;

#define _CCP9M0                 0x01
#define _CCP9M1                 0x02
#define _CCP9M2                 0x04
#define _CCP9M3                 0x08
#define _DC9B0                  0x10
#define _CCP9Y                  0x10
#define _DC9B1                  0x20
#define _CCP9X                  0x20

//==============================================================================

extern __at(0x0F44) __sfr CCPR9;
extern __at(0x0F44) __sfr CCPR9L;
extern __at(0x0F45) __sfr CCPR9H;

//==============================================================================
//        CCP8CON Bits

extern __at(0x0F46) __sfr CCP8CON;

typedef union
  {
  struct
    {
    unsigned CCP8M0             : 1;
    unsigned CCP8M1             : 1;
    unsigned CCP8M2             : 1;
    unsigned CCP8M3             : 1;
    unsigned DC8B0              : 1;
    unsigned DC8B1              : 1;
    unsigned                    : 1;
    unsigned                    : 1;
    };

  struct
    {
    unsigned                    : 1;
    unsigned                    : 1;
    unsigned                    : 1;
    unsigned                    : 1;
    unsigned CCP8Y              : 1;
    unsigned CCP8X              : 1;
    unsigned                    : 1;
    unsigned                    : 1;
    };

  struct
    {
    unsigned CCP8M              : 4;
    unsigned                    : 4;
    };

  struct
    {
    unsigned                    : 4;
    unsigned DC8B               : 2;
    unsigned                    : 2;
    };
  } __CCP8CONbits_t;

extern __at(0x0F46) volatile __CCP8CONbits_t CCP8CONbits;

#define _CCP8M0                 0x01
#define _CCP8M1                 0x02
#define _CCP8M2                 0x04
#define _CCP8M3                 0x08
#define _DC8B0                  0x10
#define _CCP8Y                  0x10
#define _DC8B1                  0x20
#define _CCP8X                  0x20

//==============================================================================

extern __at(0x0F47) __sfr CCPR8;
extern __at(0x0F47) __sfr CCPR8L;
extern __at(0x0F48) __sfr CCPR8H;

//==============================================================================
//        CCP3CON Bits

extern __at(0x0F49) __sfr CCP3CON;

typedef union
  {
  struct
    {
    unsigned CCP3M0             : 1;
    unsigned CCP3M1             : 1;
    unsigned CCP3M2             : 1;
    unsigned CCP3M3             : 1;
    unsigned DC3B0              : 1;
    unsigned DC3B1              : 1;
    unsigned P3M0               : 1;
    unsigned P3M1               : 1;
    };

  struct
    {
    unsigned CCP3M              : 4;
    unsigned                    : 4;
    };

  struct
    {
    unsigned                    : 4;
    unsigned DC3B               : 2;
    unsigned                    : 2;
    };

  struct
    {
    unsigned                    : 6;
    unsigned P3M                : 2;
    };
  } __CCP3CONbits_t;

extern __at(0x0F49) volatile __CCP3CONbits_t CCP3CONbits;

#define _CCP3M0                 0x01
#define _CCP3M1                 0x02
#define _CCP3M2                 0x04
#define _CCP3M3                 0x08
#define _DC3B0                  0x10
#define _DC3B1                  0x20
#define _P3M0                   0x40
#define _P3M1                   0x80

//==============================================================================

extern __at(0x0F4A) __sfr CCPR3;
extern __at(0x0F4A) __sfr CCPR3L;
extern __at(0x0F4B) __sfr CCPR3H;

//==============================================================================
//        ECCP3DEL Bits

extern __at(0x0F4C) __sfr ECCP3DEL;

typedef union
  {
  struct
    {
    unsigned P3DC0              : 1;
    unsigned P3DC1              : 1;
    unsigned P3DC2              : 1;
    unsigned P3DC3              : 1;
    unsigned P3DC4              : 1;
    unsigned P3DC5              : 1;
    unsigned P3DC6              : 1;
    unsigned P3RSEN             : 1;
    };

  struct
    {
    unsigned P3DC               : 7;
    unsigned                    : 1;
    };
  } __ECCP3DELbits_t;

extern __at(0x0F4C) volatile __ECCP3DELbits_t ECCP3DELbits;

#define _P3DC0                  0x01
#define _P3DC1                  0x02
#define _P3DC2                  0x04
#define _P3DC3                  0x08
#define _P3DC4                  0x10
#define _P3DC5                  0x20
#define _P3DC6                  0x40
#define _P3RSEN                 0x80

//==============================================================================


//==============================================================================
//        ECCP3AS Bits

extern __at(0x0F4D) __sfr ECCP3AS;

typedef union
  {
  struct
    {
    unsigned PSS3BD0            : 1;
    unsigned PSS3BD1            : 1;
    unsigned PSS3AC0            : 1;
    unsigned PSS3AC1            : 1;
    unsigned ECCP3AS0           : 1;
    unsigned ECCP3AS1           : 1;
    unsigned ECCP3AS2           : 1;
    unsigned ECCP3ASE           : 1;
    };

  struct
    {
    unsigned PSS3BD             : 2;
    unsigned                    : 6;
    };

  struct
    {
    unsigned                    : 2;
    unsigned PSS3AC             : 2;
    unsigned                    : 4;
    };

  struct
    {
    unsigned                    : 4;
    unsigned ECCP3AS            : 3;
    unsigned                    : 1;
    };
  } __ECCP3ASbits_t;

extern __at(0x0F4D) volatile __ECCP3ASbits_t ECCP3ASbits;

#define _PSS3BD0                0x01
#define _PSS3BD1                0x02
#define _PSS3AC0                0x04
#define _PSS3AC1                0x08
#define _ECCP3AS0               0x10
#define _ECCP3AS1               0x20
#define _ECCP3AS2               0x40
#define _ECCP3ASE               0x80

//==============================================================================


//==============================================================================
//        CCP2CON Bits

extern __at(0x0F4E) __sfr CCP2CON;

typedef union
  {
  struct
    {
    unsigned CCP2M0             : 1;
    unsigned CCP2M1             : 1;
    unsigned CCP2M2             : 1;
    unsigned CCP2M3             : 1;
    unsigned DC2B0              : 1;
    unsigned DC2B1              : 1;
    unsigned P2M0               : 1;
    unsigned P2M1               : 1;
    };

  struct
    {
    unsigned                    : 1;
    unsigned                    : 1;
    unsigned                    : 1;
    unsigned                    : 1;
    unsigned CCP2Y              : 1;
    unsigned CCP2X              : 1;
    unsigned                    : 1;
    unsigned                    : 1;
    };

  struct
    {
    unsigned CCP2M              : 4;
    unsigned                    : 4;
    };

  struct
    {
    unsigned                    : 4;
    unsigned DC2B               : 2;
    unsigned                    : 2;
    };

  struct
    {
    unsigned                    : 6;
    unsigned P2M                : 2;
    };
  } __CCP2CONbits_t;

extern __at(0x0F4E) volatile __CCP2CONbits_t CCP2CONbits;

#define _CCP2M0                 0x01
#define _CCP2M1                 0x02
#define _CCP2M2                 0x04
#define _CCP2M3                 0x08
#define _DC2B0                  0x10
#define _CCP2Y                  0x10
#define _DC2B1                  0x20
#define _CCP2X                  0x20
#define _P2M0                   0x40
#define _P2M1                   0x80

//==============================================================================


//==============================================================================
//        ECCP2CON Bits

extern __at(0x0F4E) __sfr ECCP2CON;

typedef union
  {
  struct
    {
    unsigned CCP2M0             : 1;
    unsigned CCP2M1             : 1;
    unsigned CCP2M2             : 1;
    unsigned CCP2M3             : 1;
    unsigned DC2B0              : 1;
    unsigned DC2B1              : 1;
    unsigned P2M0               : 1;
    unsigned P2M1               : 1;
    };

  struct
    {
    unsigned                    : 1;
    unsigned                    : 1;
    unsigned                    : 1;
    unsigned                    : 1;
    unsigned CCP2Y              : 1;
    unsigned CCP2X              : 1;
    unsigned                    : 1;
    unsigned                    : 1;
    };

  struct
    {
    unsigned CCP2M              : 4;
    unsigned                    : 4;
    };

  struct
    {
    unsigned                    : 4;
    unsigned DC2B               : 2;
    unsigned                    : 2;
    };

  struct
    {
    unsigned                    : 6;
    unsigned P2M                : 2;
    };
  } __ECCP2CONbits_t;

extern __at(0x0F4E) volatile __ECCP2CONbits_t ECCP2CONbits;

#define _ECCP2CON_CCP2M0        0x01
#define _ECCP2CON_CCP2M1        0x02
#define _ECCP2CON_CCP2M2        0x04
#define _ECCP2CON_CCP2M3        0x08
#define _ECCP2CON_DC2B0         0x10
#define _ECCP2CON_CCP2Y         0x10
#define _ECCP2CON_DC2B1         0x20
#define _ECCP2CON_CCP2X         0x20
#define _ECCP2CON_P2M0          0x40
#define _ECCP2CON_P2M1          0x80

//==============================================================================

extern __at(0x0F4F) __sfr CCPR2;
extern __at(0x0F4F) __sfr CCPR2L;
extern __at(0x0F50) __sfr CCPR2H;

//==============================================================================
//        ECCP2DEL Bits

extern __at(0x0F51) __sfr ECCP2DEL;

typedef union
  {
  struct
    {
    unsigned P2DC0              : 1;
    unsigned P2DC1              : 1;
    unsigned P2DC2              : 1;
    unsigned P2DC3              : 1;
    unsigned P2DC4              : 1;
    unsigned P2DC5              : 1;
    unsigned P2DC6              : 1;
    unsigned P2RSEN             : 1;
    };

  struct
    {
    unsigned P2DC               : 7;
    unsigned                    : 1;
    };
  } __ECCP2DELbits_t;

extern __at(0x0F51) volatile __ECCP2DELbits_t ECCP2DELbits;

#define _P2DC0                  0x01
#define _P2DC1                  0x02
#define _P2DC2                  0x04
#define _P2DC3                  0x08
#define _P2DC4                  0x10
#define _P2DC5                  0x20
#define _P2DC6                  0x40
#define _P2RSEN                 0x80

//==============================================================================


//==============================================================================
//        PWM2CON Bits

extern __at(0x0F51) __sfr PWM2CON;

typedef union
  {
  struct
    {
    unsigned P2DC0              : 1;
    unsigned P2DC1              : 1;
    unsigned P2DC2              : 1;
    unsigned P2DC3              : 1;
    unsigned P2DC4              : 1;
    unsigned P2DC5              : 1;
    unsigned P2DC6              : 1;
    unsigned P2RSEN             : 1;
    };

  struct
    {
    unsigned P2DC               : 7;
    unsigned                    : 1;
    };
  } __PWM2CONbits_t;

extern __at(0x0F51) volatile __PWM2CONbits_t PWM2CONbits;

#define _PWM2CON_P2DC0          0x01
#define _PWM2CON_P2DC1          0x02
#define _PWM2CON_P2DC2          0x04
#define _PWM2CON_P2DC3          0x08
#define _PWM2CON_P2DC4          0x10
#define _PWM2CON_P2DC5          0x20
#define _PWM2CON_P2DC6          0x40
#define _PWM2CON_P2RSEN         0x80

//==============================================================================


//==============================================================================
//        ECCP2AS Bits

extern __at(0x0F52) __sfr ECCP2AS;

typedef union
  {
  struct
    {
    unsigned PSS2BD0            : 1;
    unsigned PSS2BD1            : 1;
    unsigned PSS2AC0            : 1;
    unsigned PSS2AC1            : 1;
    unsigned ECCP2AS0           : 1;
    unsigned ECCP2AS1           : 1;
    unsigned ECCP2AS2           : 1;
    unsigned ECCP2ASE           : 1;
    };

  struct
    {
    unsigned PSS2BD             : 2;
    unsigned                    : 6;
    };

  struct
    {
    unsigned                    : 2;
    unsigned PSS2AC             : 2;
    unsigned                    : 4;
    };

  struct
    {
    unsigned                    : 4;
    unsigned ECCP2AS            : 3;
    unsigned                    : 1;
    };
  } __ECCP2ASbits_t;

extern __at(0x0F52) volatile __ECCP2ASbits_t ECCP2ASbits;

#define _PSS2BD0                0x01
#define _PSS2BD1                0x02
#define _PSS2AC0                0x04
#define _PSS2AC1                0x08
#define _ECCP2AS0               0x10
#define _ECCP2AS1               0x20
#define _ECCP2AS2               0x40
#define _ECCP2ASE               0x80

//==============================================================================


//==============================================================================
//        PADCFG1 Bits

extern __at(0x0F53) __sfr PADCFG1;

typedef union
  {
  struct
    {
    unsigned                    : 1;
    unsigned RTSECSEL0          : 1;
    unsigned RTSECSEL1          : 1;
    unsigned                    : 1;
    unsigned                    : 1;
    unsigned RJPU               : 1;
    unsigned REPU               : 1;
    unsigned RDPU               : 1;
    };

  struct
    {
    unsigned                    : 1;
    unsigned RTSECSEL           : 2;
    unsigned                    : 5;
    };
  } __PADCFG1bits_t;

extern __at(0x0F53) volatile __PADCFG1bits_t PADCFG1bits;

#define _RTSECSEL0              0x02
#define _RTSECSEL1              0x04
#define _RJPU                   0x20
#define _REPU                   0x40
#define _RDPU                   0x80

//==============================================================================


//==============================================================================
//        CM1CON Bits

extern __at(0x0F54) __sfr CM1CON;

typedef union
  {
  struct
    {
    unsigned CCH0               : 1;
    unsigned CCH1               : 1;
    unsigned CREF               : 1;
    unsigned EVPOL0             : 1;
    unsigned EVPOL1             : 1;
    unsigned CPOL               : 1;
    unsigned COE                : 1;
    unsigned CON                : 1;
    };

  struct
    {
    unsigned CCH                : 2;
    unsigned                    : 6;
    };

  struct
    {
    unsigned                    : 3;
    unsigned EVPOL              : 2;
    unsigned                    : 3;
    };
  } __CM1CONbits_t;

extern __at(0x0F54) volatile __CM1CONbits_t CM1CONbits;

#define _CCH0                   0x01
#define _CCH1                   0x02
#define _CREF                   0x04
#define _EVPOL0                 0x08
#define _EVPOL1                 0x10
#define _CPOL                   0x20
#define _COE                    0x40
#define _CON                    0x80

//==============================================================================


//==============================================================================
//        CM1CON1 Bits

extern __at(0x0F54) __sfr CM1CON1;

typedef union
  {
  struct
    {
    unsigned CCH0               : 1;
    unsigned CCH1               : 1;
    unsigned CREF               : 1;
    unsigned EVPOL0             : 1;
    unsigned EVPOL1             : 1;
    unsigned CPOL               : 1;
    unsigned COE                : 1;
    unsigned CON                : 1;
    };

  struct
    {
    unsigned CCH                : 2;
    unsigned                    : 6;
    };

  struct
    {
    unsigned                    : 3;
    unsigned EVPOL              : 2;
    unsigned                    : 3;
    };
  } __CM1CON1bits_t;

extern __at(0x0F54) volatile __CM1CON1bits_t CM1CON1bits;

#define _CM1CON1_CCH0           0x01
#define _CM1CON1_CCH1           0x02
#define _CM1CON1_CREF           0x04
#define _CM1CON1_EVPOL0         0x08
#define _CM1CON1_EVPOL1         0x10
#define _CM1CON1_CPOL           0x20
#define _CM1CON1_COE            0x40
#define _CM1CON1_CON            0x80

//==============================================================================


//==============================================================================
//        CTMUICON Bits

extern __at(0x0F55) __sfr CTMUICON;

typedef union
  {
  struct
    {
    unsigned IRNG0              : 1;
    unsigned IRNG1              : 1;
    unsigned ITRIM0             : 1;
    unsigned ITRIM1             : 1;
    unsigned ITRIM2             : 1;
    unsigned ITRIM3             : 1;
    unsigned ITRIM4             : 1;
    unsigned ITRIM5             : 1;
    };

  struct
    {
    unsigned IRNG               : 2;
    unsigned                    : 6;
    };

  struct
    {
    unsigned                    : 2;
    unsigned ITRIM              : 6;
    };
  } __CTMUICONbits_t;

extern __at(0x0F55) volatile __CTMUICONbits_t CTMUICONbits;

#define _IRNG0                  0x01
#define _IRNG1                  0x02
#define _ITRIM0                 0x04
#define _ITRIM1                 0x08
#define _ITRIM2                 0x10
#define _ITRIM3                 0x20
#define _ITRIM4                 0x40
#define _ITRIM5                 0x80

//==============================================================================


//==============================================================================
//        CTMUCONL Bits

extern __at(0x0F56) __sfr CTMUCONL;

typedef union
  {
  struct
    {
    unsigned EDG1STAT           : 1;
    unsigned EDG2STAT           : 1;
    unsigned EDG1SEL0           : 1;
    unsigned EDG1SEL1           : 1;
    unsigned EDG1POL            : 1;
    unsigned EDG2SEL0           : 1;
    unsigned EDG2SEL1           : 1;
    unsigned EDG2POL            : 1;
    };

  struct
    {
    unsigned                    : 2;
    unsigned EDG1SEL            : 2;
    unsigned                    : 4;
    };

  struct
    {
    unsigned                    : 5;
    unsigned EDG2SEL            : 2;
    unsigned                    : 1;
    };
  } __CTMUCONLbits_t;

extern __at(0x0F56) volatile __CTMUCONLbits_t CTMUCONLbits;

#define _EDG1STAT               0x01
#define _EDG2STAT               0x02
#define _EDG1SEL0               0x04
#define _EDG1SEL1               0x08
#define _EDG1POL                0x10
#define _EDG2SEL0               0x20
#define _EDG2SEL1               0x40
#define _EDG2POL                0x80

//==============================================================================


//==============================================================================
//        CTMUCONH Bits

extern __at(0x0F57) __sfr CTMUCONH;

typedef struct
  {
  unsigned CTTRIG               : 1;
  unsigned IDISSEN              : 1;
  unsigned EDGSEQEN             : 1;
  unsigned EDGEN                : 1;
  unsigned TGEN                 : 1;
  unsigned CTMUSIDL             : 1;
  unsigned                      : 1;
  unsigned CTMUEN               : 1;
  } __CTMUCONHbits_t;

extern __at(0x0F57) volatile __CTMUCONHbits_t CTMUCONHbits;

#define _CTTRIG                 0x01
#define _IDISSEN                0x02
#define _EDGSEQEN               0x04
#define _EDGEN                  0x08
#define _TGEN                   0x10
#define _CTMUSIDL               0x20
#define _CTMUEN                 0x80

//==============================================================================

extern __at(0x0F58) __sfr ALRMVAL;
extern __at(0x0F58) __sfr ALRMVALL;
extern __at(0x0F59) __sfr ALRMVALH;

//==============================================================================
//        ALRMRPT Bits

extern __at(0x0F5A) __sfr ALRMRPT;

typedef struct
  {
  unsigned ARPT0                : 1;
  unsigned ARPT1                : 1;
  unsigned ARPT2                : 1;
  unsigned ARPT3                : 1;
  unsigned ARPT4                : 1;
  unsigned ARPT5                : 1;
  unsigned ARPT6                : 1;
  unsigned ARPT7                : 1;
  } __ALRMRPTbits_t;

extern __at(0x0F5A) volatile __ALRMRPTbits_t ALRMRPTbits;

#define _ARPT0                  0x01
#define _ARPT1                  0x02
#define _ARPT2                  0x04
#define _ARPT3                  0x08
#define _ARPT4                  0x10
#define _ARPT5                  0x20
#define _ARPT6                  0x40
#define _ARPT7                  0x80

//==============================================================================


//==============================================================================
//        ALRMCFG Bits

extern __at(0x0F5B) __sfr ALRMCFG;

typedef union
  {
  struct
    {
    unsigned ALRMPTR0           : 1;
    unsigned ALRMPTR1           : 1;
    unsigned AMASK0             : 1;
    unsigned AMASK1             : 1;
    unsigned AMASK2             : 1;
    unsigned AMASK3             : 1;
    unsigned CHIME              : 1;
    unsigned ALRMEN             : 1;
    };

  struct
    {
    unsigned ALRMPTR            : 2;
    unsigned                    : 6;
    };

  struct
    {
    unsigned                    : 2;
    unsigned AMASK              : 4;
    unsigned                    : 2;
    };
  } __ALRMCFGbits_t;

extern __at(0x0F5B) volatile __ALRMCFGbits_t ALRMCFGbits;

#define _ALRMPTR0               0x01
#define _ALRMPTR1               0x02
#define _AMASK0                 0x04
#define _AMASK1                 0x08
#define _AMASK2                 0x10
#define _AMASK3                 0x20
#define _CHIME                  0x40
#define _ALRMEN                 0x80

//==============================================================================

extern __at(0x0F5C) __sfr RTCVAL;
extern __at(0x0F5C) __sfr RTCVALL;
extern __at(0x0F5D) __sfr RTCVALH;

//==============================================================================
//        RTCCAL Bits

extern __at(0x0F5E) __sfr RTCCAL;

typedef struct
  {
  unsigned CAL0                 : 1;
  unsigned CAL1                 : 1;
  unsigned CAL2                 : 1;
  unsigned CAL3                 : 1;
  unsigned CAL4                 : 1;
  unsigned CAL5                 : 1;
  unsigned CAL6                 : 1;
  unsigned CAL7                 : 1;
  } __RTCCALbits_t;

extern __at(0x0F5E) volatile __RTCCALbits_t RTCCALbits;

#define _CAL0                   0x01
#define _CAL1                   0x02
#define _CAL2                   0x04
#define _CAL3                   0x08
#define _CAL4                   0x10
#define _CAL5                   0x20
#define _CAL6                   0x40
#define _CAL7                   0x80

//==============================================================================


//==============================================================================
//        RTCCFG Bits

extern __at(0x0F5F) __sfr RTCCFG;

typedef union
  {
  struct
    {
    unsigned RTCPTR0            : 1;
    unsigned RTCPTR1            : 1;
    unsigned RTCOE              : 1;
    unsigned HALFSEC            : 1;
    unsigned RTCSYNC            : 1;
    unsigned RTCWREN            : 1;
    unsigned                    : 1;
    unsigned RTCEN              : 1;
    };

  struct
    {
    unsigned RTCPTR             : 2;
    unsigned                    : 6;
    };
  } __RTCCFGbits_t;

extern __at(0x0F5F) volatile __RTCCFGbits_t RTCCFGbits;

#define _RTCPTR0                0x01
#define _RTCPTR1                0x02
#define _RTCOE                  0x04
#define _HALFSEC                0x08
#define _RTCSYNC                0x10
#define _RTCWREN                0x20
#define _RTCEN                  0x80

//==============================================================================


//==============================================================================
//        PIE6 Bits

extern __at(0x0F60) __sfr PIE6;

typedef struct
  {
  unsigned CMP1IE               : 1;
  unsigned CMP2IE               : 1;
  unsigned CMP3IE               : 1;
  unsigned                      : 1;
  unsigned EEIE                 : 1;
  unsigned                      : 1;
  unsigned                      : 1;
  unsigned                      : 1;
  } __PIE6bits_t;

extern __at(0x0F60) volatile __PIE6bits_t PIE6bits;

#define _CMP1IE                 0x01
#define _CMP2IE                 0x02
#define _CMP3IE                 0x04
#define _EEIE                   0x10

//==============================================================================

extern __at(0x0F61) __sfr EEDATA;
extern __at(0x0F62) __sfr EEADR;
extern __at(0x0F63) __sfr EEADRH;

//==============================================================================
//        OSCCON2 Bits

extern __at(0x0F64) __sfr OSCCON2;

typedef struct
  {
  unsigned MFIOSEL              : 1;
  unsigned MFIOFS               : 1;
  unsigned                      : 1;
  unsigned SOSCGO               : 1;
  unsigned                      : 1;
  unsigned                      : 1;
  unsigned SOSCRUN              : 1;
  unsigned                      : 1;
  } __OSCCON2bits_t;

extern __at(0x0F64) volatile __OSCCON2bits_t OSCCON2bits;

#define _MFIOSEL                0x01
#define _MFIOFS                 0x02
#define _SOSCGO                 0x08
#define _SOSCRUN                0x40

//==============================================================================


//==============================================================================
//        BAUDCON Bits

extern __at(0x0F65) __sfr BAUDCON;

typedef struct
  {
  unsigned ABDEN                : 1;
  unsigned WUE                  : 1;
  unsigned                      : 1;
  unsigned BRG16                : 1;
  unsigned TXCKP                : 1;
  unsigned RXDTP                : 1;
  unsigned RCIDL                : 1;
  unsigned ABDOVF               : 1;
  } __BAUDCONbits_t;

extern __at(0x0F65) volatile __BAUDCONbits_t BAUDCONbits;

#define _ABDEN                  0x01
#define _WUE                    0x02
#define _BRG16                  0x08
#define _TXCKP                  0x10
#define _RXDTP                  0x20
#define _RCIDL                  0x40
#define _ABDOVF                 0x80

//==============================================================================


//==============================================================================
//        BAUDCON1 Bits

extern __at(0x0F65) __sfr BAUDCON1;

typedef struct
  {
  unsigned ABDEN                : 1;
  unsigned WUE                  : 1;
  unsigned                      : 1;
  unsigned BRG16                : 1;
  unsigned TXCKP                : 1;
  unsigned RXDTP                : 1;
  unsigned RCIDL                : 1;
  unsigned ABDOVF               : 1;
  } __BAUDCON1bits_t;

extern __at(0x0F65) volatile __BAUDCON1bits_t BAUDCON1bits;

#define _BAUDCON1_ABDEN         0x01
#define _BAUDCON1_WUE           0x02
#define _BAUDCON1_BRG16         0x08
#define _BAUDCON1_TXCKP         0x10
#define _BAUDCON1_RXDTP         0x20
#define _BAUDCON1_RCIDL         0x40
#define _BAUDCON1_ABDOVF        0x80

//==============================================================================


//==============================================================================
//        BAUDCTL Bits

extern __at(0x0F65) __sfr BAUDCTL;

typedef struct
  {
  unsigned ABDEN                : 1;
  unsigned WUE                  : 1;
  unsigned                      : 1;
  unsigned BRG16                : 1;
  unsigned TXCKP                : 1;
  unsigned RXDTP                : 1;
  unsigned RCIDL                : 1;
  unsigned ABDOVF               : 1;
  } __BAUDCTLbits_t;

extern __at(0x0F65) volatile __BAUDCTLbits_t BAUDCTLbits;

#define _BAUDCTL_ABDEN          0x01
#define _BAUDCTL_WUE            0x02
#define _BAUDCTL_BRG16          0x08
#define _BAUDCTL_TXCKP          0x10
#define _BAUDCTL_RXDTP          0x20
#define _BAUDCTL_RCIDL          0x40
#define _BAUDCTL_ABDOVF         0x80

//==============================================================================


//==============================================================================
//        SSP2CON2 Bits

extern __at(0x0F66) __sfr SSP2CON2;

typedef union
  {
  struct
    {
    unsigned SEN                : 1;
    unsigned RSEN               : 1;
    unsigned PEN                : 1;
    unsigned RCEN               : 1;
    unsigned ACKEN              : 1;
    unsigned ACKDT              : 1;
    unsigned ACKSTAT            : 1;
    unsigned GCEN               : 1;
    };

  struct
    {
    unsigned                    : 1;
    unsigned ADMSK1             : 1;
    unsigned ADMSK2             : 1;
    unsigned ADMSK3             : 1;
    unsigned ADMSK4             : 1;
    unsigned ADMSK5             : 1;
    unsigned                    : 1;
    unsigned                    : 1;
    };
  } __SSP2CON2bits_t;

extern __at(0x0F66) volatile __SSP2CON2bits_t SSP2CON2bits;

#define _SSP2CON2_SEN           0x01
#define _SSP2CON2_RSEN          0x02
#define _SSP2CON2_ADMSK1        0x02
#define _SSP2CON2_PEN           0x04
#define _SSP2CON2_ADMSK2        0x04
#define _SSP2CON2_RCEN          0x08
#define _SSP2CON2_ADMSK3        0x08
#define _SSP2CON2_ACKEN         0x10
#define _SSP2CON2_ADMSK4        0x10
#define _SSP2CON2_ACKDT         0x20
#define _SSP2CON2_ADMSK5        0x20
#define _SSP2CON2_ACKSTAT       0x40
#define _SSP2CON2_GCEN          0x80

//==============================================================================


//==============================================================================
//        SSP2CON1 Bits

extern __at(0x0F67) __sfr SSP2CON1;

typedef union
  {
  struct
    {
    unsigned SSPM0              : 1;
    unsigned SSPM1              : 1;
    unsigned SSPM2              : 1;
    unsigned SSPM3              : 1;
    unsigned CKP                : 1;
    unsigned SSPEN              : 1;
    unsigned SSPOV              : 1;
    unsigned WCOL               : 1;
    };

  struct
    {
    unsigned SSPM               : 4;
    unsigned                    : 4;
    };
  } __SSP2CON1bits_t;

extern __at(0x0F67) volatile __SSP2CON1bits_t SSP2CON1bits;

#define _SSP2CON1_SSPM0         0x01
#define _SSP2CON1_SSPM1         0x02
#define _SSP2CON1_SSPM2         0x04
#define _SSP2CON1_SSPM3         0x08
#define _SSP2CON1_CKP           0x10
#define _SSP2CON1_SSPEN         0x20
#define _SSP2CON1_SSPOV         0x40
#define _SSP2CON1_WCOL          0x80

//==============================================================================


//==============================================================================
//        SSP2STAT Bits

extern __at(0x0F68) __sfr SSP2STAT;

typedef union
  {
  struct
    {
    unsigned BF                 : 1;
    unsigned UA                 : 1;
    unsigned R_NOT_W            : 1;
    unsigned S                  : 1;
    unsigned P                  : 1;
    unsigned D_NOT_A            : 1;
    unsigned CKE                : 1;
    unsigned SMP                : 1;
    };

  struct
    {
    unsigned                    : 1;
    unsigned                    : 1;
    unsigned R                  : 1;
    unsigned I2C_START          : 1;
    unsigned I2C_STOP           : 1;
    unsigned D                  : 1;
    unsigned                    : 1;
    unsigned                    : 1;
    };

  struct
    {
    unsigned                    : 1;
    unsigned                    : 1;
    unsigned R_W                : 1;
    unsigned                    : 1;
    unsigned                    : 1;
    unsigned D_A                : 1;
    unsigned                    : 1;
    unsigned                    : 1;
    };

  struct
    {
    unsigned                    : 1;
    unsigned                    : 1;
    unsigned NOT_W              : 1;
    unsigned                    : 1;
    unsigned                    : 1;
    unsigned NOT_A              : 1;
    unsigned                    : 1;
    unsigned                    : 1;
    };

  struct
    {
    unsigned                    : 1;
    unsigned                    : 1;
    unsigned NOT_WRITE          : 1;
    unsigned                    : 1;
    unsigned                    : 1;
    unsigned NOT_ADDRESS        : 1;
    unsigned                    : 1;
    unsigned                    : 1;
    };

  struct
    {
    unsigned                    : 1;
    unsigned                    : 1;
    unsigned READ_WRITE         : 1;
    unsigned                    : 1;
    unsigned                    : 1;
    unsigned DATA_ADDRESS       : 1;
    unsigned                    : 1;
    unsigned                    : 1;
    };

  struct
    {
    unsigned                    : 1;
    unsigned                    : 1;
    unsigned I2C_READ           : 1;
    unsigned                    : 1;
    unsigned                    : 1;
    unsigned I2C_DAT            : 1;
    unsigned                    : 1;
    unsigned                    : 1;
    };
  } __SSP2STATbits_t;

extern __at(0x0F68) volatile __SSP2STATbits_t SSP2STATbits;

#define _SSP2STAT_BF            0x01
#define _SSP2STAT_UA            0x02
#define _SSP2STAT_R_NOT_W       0x04
#define _SSP2STAT_R             0x04
#define _SSP2STAT_R_W           0x04
#define _SSP2STAT_NOT_W         0x04
#define _SSP2STAT_NOT_WRITE     0x04
#define _SSP2STAT_READ_WRITE    0x04
#define _SSP2STAT_I2C_READ      0x04
#define _SSP2STAT_S             0x08
#define _SSP2STAT_I2C_START     0x08
#define _SSP2STAT_P             0x10
#define _SSP2STAT_I2C_STOP      0x10
#define _SSP2STAT_D_NOT_A       0x20
#define _SSP2STAT_D             0x20
#define _SSP2STAT_D_A           0x20
#define _SSP2STAT_NOT_A         0x20
#define _SSP2STAT_NOT_ADDRESS   0x20
#define _SSP2STAT_DATA_ADDRESS  0x20
#define _SSP2STAT_I2C_DAT       0x20
#define _SSP2STAT_CKE           0x40
#define _SSP2STAT_SMP           0x80

//==============================================================================

extern __at(0x0F69) __sfr SSP2ADD;

//==============================================================================
//        SSP2MSK Bits

extern __at(0x0F69) __sfr SSP2MSK;

typedef struct
  {
  unsigned MSK0                 : 1;
  unsigned MSK1                 : 1;
  unsigned MSK2                 : 1;
  unsigned MSK3                 : 1;
  unsigned MSK4                 : 1;
  unsigned MSK5                 : 1;
  unsigned MSK6                 : 1;
  unsigned MSK7                 : 1;
  } __SSP2MSKbits_t;

extern __at(0x0F69) volatile __SSP2MSKbits_t SSP2MSKbits;

#define _SSP2MSK_MSK0           0x01
#define _SSP2MSK_MSK1           0x02
#define _SSP2MSK_MSK2           0x04
#define _SSP2MSK_MSK3           0x08
#define _SSP2MSK_MSK4           0x10
#define _SSP2MSK_MSK5           0x20
#define _SSP2MSK_MSK6           0x40
#define _SSP2MSK_MSK7           0x80

//==============================================================================

extern __at(0x0F6A) __sfr SSP2BUF;

//==============================================================================
//        T4CON Bits

extern __at(0x0F6B) __sfr T4CON;

typedef union
  {
  struct
    {
    unsigned T4CKPS0            : 1;
    unsigned T4CKPS1            : 1;
    unsigned TMR4ON             : 1;
    unsigned T4OUTPS0           : 1;
    unsigned T4OUTPS1           : 1;
    unsigned T4OUTPS2           : 1;
    unsigned T4OUTPS3           : 1;
    unsigned                    : 1;
    };

  struct
    {
    unsigned T4CKPS             : 2;
    unsigned                    : 6;
    };

  struct
    {
    unsigned                    : 3;
    unsigned T4OUTPS            : 4;
    unsigned                    : 1;
    };
  } __T4CONbits_t;

extern __at(0x0F6B) volatile __T4CONbits_t T4CONbits;

#define _T4CKPS0                0x01
#define _T4CKPS1                0x02
#define _TMR4ON                 0x04
#define _T4OUTPS0               0x08
#define _T4OUTPS1               0x10
#define _T4OUTPS2               0x20
#define _T4OUTPS3               0x40

//==============================================================================

extern __at(0x0F6C) __sfr PR4;
extern __at(0x0F6D) __sfr TMR4;

//==============================================================================
//        CCP7CON Bits

extern __at(0x0F6E) __sfr CCP7CON;

typedef union
  {
  struct
    {
    unsigned CCP7M0             : 1;
    unsigned CCP7M1             : 1;
    unsigned CCP7M2             : 1;
    unsigned CCP7M3             : 1;
    unsigned DC7B0              : 1;
    unsigned DC7B1              : 1;
    unsigned                    : 1;
    unsigned                    : 1;
    };

  struct
    {
    unsigned                    : 1;
    unsigned                    : 1;
    unsigned                    : 1;
    unsigned                    : 1;
    unsigned CCP7Y              : 1;
    unsigned CCP7X              : 1;
    unsigned                    : 1;
    unsigned                    : 1;
    };

  struct
    {
    unsigned CCP7M              : 4;
    unsigned                    : 4;
    };

  struct
    {
    unsigned                    : 4;
    unsigned DC7B               : 2;
    unsigned                    : 2;
    };
  } __CCP7CONbits_t;

extern __at(0x0F6E) volatile __CCP7CONbits_t CCP7CONbits;

#define _CCP7M0                 0x01
#define _CCP7M1                 0x02
#define _CCP7M2                 0x04
#define _CCP7M3                 0x08
#define _DC7B0                  0x10
#define _CCP7Y                  0x10
#define _DC7B1                  0x20
#define _CCP7X                  0x20

//==============================================================================

extern __at(0x0F6F) __sfr CCPR7;
extern __at(0x0F6F) __sfr CCPR7L;
extern __at(0x0F70) __sfr CCPR7H;

//==============================================================================
//        CCP6CON Bits

extern __at(0x0F71) __sfr CCP6CON;

typedef union
  {
  struct
    {
    unsigned CCP6M0             : 1;
    unsigned CCP6M1             : 1;
    unsigned CCP6M2             : 1;
    unsigned CCP6M3             : 1;
    unsigned DC6B0              : 1;
    unsigned DC6B1              : 1;
    unsigned                    : 1;
    unsigned                    : 1;
    };

  struct
    {
    unsigned                    : 1;
    unsigned                    : 1;
    unsigned                    : 1;
    unsigned                    : 1;
    unsigned CCP6Y              : 1;
    unsigned CCP6X              : 1;
    unsigned                    : 1;
    unsigned                    : 1;
    };

  struct
    {
    unsigned CCP6M              : 4;
    unsigned                    : 4;
    };

  struct
    {
    unsigned                    : 4;
    unsigned DC6B               : 2;
    unsigned                    : 2;
    };
  } __CCP6CONbits_t;

extern __at(0x0F71) volatile __CCP6CONbits_t CCP6CONbits;

#define _CCP6M0                 0x01
#define _CCP6M1                 0x02
#define _CCP6M2                 0x04
#define _CCP6M3                 0x08
#define _DC6B0                  0x10
#define _CCP6Y                  0x10
#define _DC6B1                  0x20
#define _CCP6X                  0x20

//==============================================================================

extern __at(0x0F72) __sfr CCPR6;
extern __at(0x0F72) __sfr CCPR6L;
extern __at(0x0F73) __sfr CCPR6H;

//==============================================================================
//        CCP5CON Bits

extern __at(0x0F74) __sfr CCP5CON;

typedef union
  {
  struct
    {
    unsigned CCP5M0             : 1;
    unsigned CCP5M1             : 1;
    unsigned CCP5M2             : 1;
    unsigned CCP5M3             : 1;
    unsigned DC5B0              : 1;
    unsigned DC5B1              : 1;
    unsigned                    : 1;
    unsigned                    : 1;
    };

  struct
    {
    unsigned                    : 1;
    unsigned                    : 1;
    unsigned                    : 1;
    unsigned                    : 1;
    unsigned CCP5Y              : 1;
    unsigned CCP5X              : 1;
    unsigned                    : 1;
    unsigned                    : 1;
    };

  struct
    {
    unsigned CCP5M              : 4;
    unsigned                    : 4;
    };

  struct
    {
    unsigned                    : 4;
    unsigned DC5B               : 2;
    unsigned                    : 2;
    };
  } __CCP5CONbits_t;

extern __at(0x0F74) volatile __CCP5CONbits_t CCP5CONbits;

#define _CCP5M0                 0x01
#define _CCP5M1                 0x02
#define _CCP5M2                 0x04
#define _CCP5M3                 0x08
#define _DC5B0                  0x10
#define _CCP5Y                  0x10
#define _DC5B1                  0x20
#define _CCP5X                  0x20

//==============================================================================

extern __at(0x0F75) __sfr CCPR5;
extern __at(0x0F75) __sfr CCPR5L;
extern __at(0x0F76) __sfr CCPR5H;

//==============================================================================
//        CCP4CON Bits

extern __at(0x0F77) __sfr CCP4CON;

typedef union
  {
  struct
    {
    unsigned CCP4M0             : 1;
    unsigned CCP4M1             : 1;
    unsigned CCP4M2             : 1;
    unsigned CCP4M3             : 1;
    unsigned DC4B0              : 1;
    unsigned DC4B1              : 1;
    unsigned                    : 1;
    unsigned                    : 1;
    };

  struct
    {
    unsigned                    : 1;
    unsigned                    : 1;
    unsigned                    : 1;
    unsigned                    : 1;
    unsigned CCP4Y              : 1;
    unsigned CCP4X              : 1;
    unsigned                    : 1;
    unsigned                    : 1;
    };

  struct
    {
    unsigned CCP4M              : 4;
    unsigned                    : 4;
    };

  struct
    {
    unsigned                    : 4;
    unsigned DC4B               : 2;
    unsigned                    : 2;
    };
  } __CCP4CONbits_t;

extern __at(0x0F77) volatile __CCP4CONbits_t CCP4CONbits;

#define _CCP4M0                 0x01
#define _CCP4M1                 0x02
#define _CCP4M2                 0x04
#define _CCP4M3                 0x08
#define _DC4B0                  0x10
#define _CCP4Y                  0x10
#define _DC4B1                  0x20
#define _CCP4X                  0x20

//==============================================================================

extern __at(0x0F78) __sfr CCPR4;
extern __at(0x0F78) __sfr CCPR4L;
extern __at(0x0F79) __sfr CCPR4H;

//==============================================================================
//        T5GCON Bits

extern __at(0x0F7A) __sfr T5GCON;

typedef union
  {
  struct
    {
    unsigned T5GSS0             : 1;
    unsigned T5GSS1             : 1;
    unsigned T5GVAL             : 1;
    unsigned T5GGO_NOT_T5DONE   : 1;
    unsigned T5GSPM             : 1;
    unsigned T5GTM              : 1;
    unsigned T5GPOL             : 1;
    unsigned TMR5GE             : 1;
    };

  struct
    {
    unsigned                    : 1;
    unsigned                    : 1;
    unsigned                    : 1;
    unsigned T5GGO              : 1;
    unsigned                    : 1;
    unsigned                    : 1;
    unsigned                    : 1;
    unsigned                    : 1;
    };

  struct
    {
    unsigned                    : 1;
    unsigned                    : 1;
    unsigned                    : 1;
    unsigned NOT_T5DONE         : 1;
    unsigned                    : 1;
    unsigned                    : 1;
    unsigned                    : 1;
    unsigned                    : 1;
    };

  struct
    {
    unsigned T5GSS              : 2;
    unsigned                    : 6;
    };
  } __T5GCONbits_t;

extern __at(0x0F7A) volatile __T5GCONbits_t T5GCONbits;

#define _T5GSS0                 0x01
#define _T5GSS1                 0x02
#define _T5GVAL                 0x04
#define _T5GGO_NOT_T5DONE       0x08
#define _T5GGO                  0x08
#define _NOT_T5DONE             0x08
#define _T5GSPM                 0x10
#define _T5GTM                  0x20
#define _T5GPOL                 0x40
#define _TMR5GE                 0x80

//==============================================================================


//==============================================================================
//        T5CON Bits

extern __at(0x0F7B) __sfr T5CON;

typedef union
  {
  struct
    {
    unsigned TMR5ON             : 1;
    unsigned RD16               : 1;
    unsigned NOT_T5SYNC         : 1;
    unsigned SOSCEN             : 1;
    unsigned T5CKPS0            : 1;
    unsigned T5CKPS1            : 1;
    unsigned TMR5CS0            : 1;
    unsigned TMR5CS1            : 1;
    };

  struct
    {
    unsigned                    : 4;
    unsigned T5CKPS             : 2;
    unsigned                    : 2;
    };

  struct
    {
    unsigned                    : 6;
    unsigned TMR5CS             : 2;
    };
  } __T5CONbits_t;

extern __at(0x0F7B) volatile __T5CONbits_t T5CONbits;

#define _T5CON_TMR5ON           0x01
#define _T5CON_RD16             0x02
#define _T5CON_NOT_T5SYNC       0x04
#define _T5CON_SOSCEN           0x08
#define _T5CON_T5CKPS0          0x10
#define _T5CON_T5CKPS1          0x20
#define _T5CON_TMR5CS0          0x40
#define _T5CON_TMR5CS1          0x80

//==============================================================================

extern __at(0x0F7C) __sfr TMR5;
extern __at(0x0F7C) __sfr TMR5L;
extern __at(0x0F7D) __sfr TMR5H;
extern __at(0x0F7E) __sfr EECON2;

//==============================================================================
//        EECON1 Bits

extern __at(0x0F7F) __sfr EECON1;

typedef struct
  {
  unsigned RD                   : 1;
  unsigned WR                   : 1;
  unsigned WREN                 : 1;
  unsigned WRERR                : 1;
  unsigned FREE                 : 1;
  unsigned                      : 1;
  unsigned CFGS                 : 1;
  unsigned EEPGD                : 1;
  } __EECON1bits_t;

extern __at(0x0F7F) volatile __EECON1bits_t EECON1bits;

#define _RD                     0x01
#define _WR                     0x02
#define _WREN                   0x04
#define _WRERR                  0x08
#define _FREE                   0x10
#define _CFGS                   0x40
#define _EEPGD                  0x80

//==============================================================================


//==============================================================================
//        PORTA Bits

extern __at(0x0F80) __sfr PORTA;

typedef union
  {
  struct
    {
    unsigned RA0                : 1;
    unsigned RA1                : 1;
    unsigned RA2                : 1;
    unsigned RA3                : 1;
    unsigned RA4                : 1;
    unsigned RA5                : 1;
    unsigned RA6                : 1;
    unsigned RA7                : 1;
    };

  struct
    {
    unsigned AN0                : 1;
    unsigned AN1                : 1;
    unsigned AN2                : 1;
    unsigned AN3                : 1;
    unsigned T0CKI              : 1;
    unsigned AN4                : 1;
    unsigned OSC2               : 1;
    unsigned OSC1               : 1;
    };

  struct
    {
    unsigned ULPWU              : 1;
    unsigned                    : 1;
    unsigned VREF_MINUS         : 1;
    unsigned VREF_PLUS          : 1;
    unsigned                    : 1;
    unsigned T1CKI              : 1;
    unsigned CLKO               : 1;
    unsigned CLKI               : 1;
    };

  struct
    {
    unsigned                    : 1;
    unsigned                    : 1;
    unsigned                    : 1;
    unsigned                    : 1;
    unsigned                    : 1;
    unsigned T3G                : 1;
    unsigned                    : 1;
    unsigned                    : 1;
    };

  struct
    {
    unsigned                    : 1;
    unsigned                    : 1;
    unsigned                    : 1;
    unsigned                    : 1;
    unsigned                    : 1;
    unsigned HLVDIN             : 1;
    unsigned                    : 1;
    unsigned                    : 1;
    };
  } __PORTAbits_t;

extern __at(0x0F80) volatile __PORTAbits_t PORTAbits;

#define _RA0                    0x01
#define _AN0                    0x01
#define _ULPWU                  0x01
#define _RA1                    0x02
#define _AN1                    0x02
#define _RA2                    0x04
#define _AN2                    0x04
#define _VREF_MINUS             0x04
#define _RA3                    0x08
#define _AN3                    0x08
#define _VREF_PLUS              0x08
#define _RA4                    0x10
#define _T0CKI                  0x10
#define _RA5                    0x20
#define _AN4                    0x20
#define _T1CKI                  0x20
#define _T3G                    0x20
#define _HLVDIN                 0x20
#define _RA6                    0x40
#define _OSC2                   0x40
#define _CLKO                   0x40
#define _RA7                    0x80
#define _OSC1                   0x80
#define _CLKI                   0x80

//==============================================================================


//==============================================================================
//        PORTB Bits

extern __at(0x0F81) __sfr PORTB;

typedef union
  {
  struct
    {
    unsigned RB0                : 1;
    unsigned RB1                : 1;
    unsigned RB2                : 1;
    unsigned RB3                : 1;
    unsigned RB4                : 1;
    unsigned RB5                : 1;
    unsigned RB6                : 1;
    unsigned RB7                : 1;
    };

  struct
    {
    unsigned INT0               : 1;
    unsigned INT1               : 1;
    unsigned INT2               : 1;
    unsigned INT3               : 1;
    unsigned KBI0               : 1;
    unsigned KBI1               : 1;
    unsigned KBI2               : 1;
    unsigned KBI3               : 1;
    };

  struct
    {
    unsigned FLT0               : 1;
    unsigned                    : 1;
    unsigned CTED1              : 1;
    unsigned CTED2              : 1;
    unsigned                    : 1;
    unsigned T3CKI              : 1;
    unsigned PGC                : 1;
    unsigned PGD                : 1;
    };

  struct
    {
    unsigned                    : 1;
    unsigned                    : 1;
    unsigned                    : 1;
    unsigned CCP2_P2A           : 1;
    unsigned                    : 1;
    unsigned T1G                : 1;
    unsigned                    : 1;
    unsigned                    : 1;
    };

  struct
    {
    unsigned                    : 1;
    unsigned                    : 1;
    unsigned                    : 1;
    unsigned                    : 1;
    unsigned                    : 1;
    unsigned PGM                : 1;
    unsigned                    : 1;
    unsigned                    : 1;
    };

  struct
    {
    unsigned INT                : 4;
    unsigned                    : 4;
    };

  struct
    {
    unsigned                    : 4;
    unsigned KBI                : 4;
    };
  } __PORTBbits_t;

extern __at(0x0F81) volatile __PORTBbits_t PORTBbits;

#define _RB0                    0x01
#define _INT0                   0x01
#define _FLT0                   0x01
#define _RB1                    0x02
#define _INT1                   0x02
#define _RB2                    0x04
#define _INT2                   0x04
#define _CTED1                  0x04
#define _RB3                    0x08
#define _INT3                   0x08
#define _CTED2                  0x08
#define _CCP2_P2A               0x08
#define _RB4                    0x10
#define _KBI0                   0x10
#define _RB5                    0x20
#define _KBI1                   0x20
#define _T3CKI                  0x20
#define _T1G                    0x20
#define _PGM                    0x20
#define _RB6                    0x40
#define _KBI2                   0x40
#define _PGC                    0x40
#define _RB7                    0x80
#define _KBI3                   0x80
#define _PGD                    0x80

//==============================================================================


//==============================================================================
//        PORTC Bits

extern __at(0x0F82) __sfr PORTC;

typedef union
  {
  struct
    {
    unsigned RC0                : 1;
    unsigned RC1                : 1;
    unsigned RC2                : 1;
    unsigned RC3                : 1;
    unsigned RC4                : 1;
    unsigned RC5                : 1;
    unsigned RC6                : 1;
    unsigned RC7                : 1;
    };

  struct
    {
    unsigned SOSCO              : 1;
    unsigned SOSCI              : 1;
    unsigned CCP1               : 1;
    unsigned SCK1               : 1;
    unsigned SDI1               : 1;
    unsigned SDO1               : 1;
    unsigned TX1                : 1;
    unsigned RX1                : 1;
    };

  struct
    {
    unsigned SCKLI              : 1;
    unsigned CCP2               : 1;
    unsigned P1A                : 1;
    unsigned SCL1               : 1;
    unsigned SDA1               : 1;
    unsigned                    : 1;
    unsigned CK1                : 1;
    unsigned DT1                : 1;
    };

  struct
    {
    unsigned                    : 1;
    unsigned P2A                : 1;
    unsigned                    : 1;
    unsigned                    : 1;
    unsigned                    : 1;
    unsigned                    : 1;
    unsigned                    : 1;
    unsigned                    : 1;
    };
  } __PORTCbits_t;

extern __at(0x0F82) volatile __PORTCbits_t PORTCbits;

#define _RC0                    0x01
#define _SOSCO                  0x01
#define _SCKLI                  0x01
#define _RC1                    0x02
#define _SOSCI                  0x02
#define _CCP2                   0x02
#define _P2A                    0x02
#define _RC2                    0x04
#define _CCP1                   0x04
#define _P1A                    0x04
#define _RC3                    0x08
#define _SCK1                   0x08
#define _SCL1                   0x08
#define _RC4                    0x10
#define _SDI1                   0x10
#define _SDA1                   0x10
#define _RC5                    0x20
#define _SDO1                   0x20
#define _RC6                    0x40
#define _TX1                    0x40
#define _CK1                    0x40
#define _RC7                    0x80
#define _RX1                    0x80
#define _DT1                    0x80

//==============================================================================


//==============================================================================
//        PORTD Bits

extern __at(0x0F83) __sfr PORTD;

typedef union
  {
  struct
    {
    unsigned RD0                : 1;
    unsigned RD1                : 1;
    unsigned RD2                : 1;
    unsigned RD3                : 1;
    unsigned RD4                : 1;
    unsigned RD5                : 1;
    unsigned RD6                : 1;
    unsigned RD7                : 1;
    };

  struct
    {
    unsigned AD0                : 1;
    unsigned AD1                : 1;
    unsigned AD2                : 1;
    unsigned AD3                : 1;
    unsigned AD4                : 1;
    unsigned AD5                : 1;
    unsigned AD6                : 1;
    unsigned AD7                : 1;
    };

  struct
    {
    unsigned PSP0               : 1;
    unsigned PSP1               : 1;
    unsigned PSP2               : 1;
    unsigned PSP3               : 1;
    unsigned PSP4               : 1;
    unsigned PSP5               : 1;
    unsigned PSP6               : 1;
    unsigned PSP7               : 1;
    };

  struct
    {
    unsigned CTPLS              : 1;
    unsigned T5CKI              : 1;
    unsigned                    : 1;
    unsigned                    : 1;
    unsigned SDO2               : 1;
    unsigned SDI2               : 1;
    unsigned SCK2               : 1;
    unsigned NOT_SS2            : 1;
    };

  struct
    {
    unsigned                    : 1;
    unsigned T7G                : 1;
    unsigned                    : 1;
    unsigned                    : 1;
    unsigned                    : 1;
    unsigned SDA2               : 1;
    unsigned SCL2               : 1;
    unsigned                    : 1;
    };
  } __PORTDbits_t;

extern __at(0x0F83) volatile __PORTDbits_t PORTDbits;

#define _RD0                    0x01
#define _AD0                    0x01
#define _PSP0                   0x01
#define _CTPLS                  0x01
#define _RD1                    0x02
#define _AD1                    0x02
#define _PSP1                   0x02
#define _T5CKI                  0x02
#define _T7G                    0x02
#define _RD2                    0x04
#define _AD2                    0x04
#define _PSP2                   0x04
#define _RD3                    0x08
#define _AD3                    0x08
#define _PSP3                   0x08
#define _RD4                    0x10
#define _AD4                    0x10
#define _PSP4                   0x10
#define _SDO2                   0x10
#define _RD5                    0x20
#define _AD5                    0x20
#define _PSP5                   0x20
#define _SDI2                   0x20
#define _SDA2                   0x20
#define _RD6                    0x40
#define _AD6                    0x40
#define _PSP6                   0x40
#define _SCK2                   0x40
#define _SCL2                   0x40
#define _RD7                    0x80
#define _AD7                    0x80
#define _PSP7                   0x80
#define _NOT_SS2                0x80

//==============================================================================


//==============================================================================
//        PORTE Bits

extern __at(0x0F84) __sfr PORTE;

typedef union
  {
  struct
    {
    unsigned RE0                : 1;
    unsigned RE1                : 1;
    unsigned RE2                : 1;
    unsigned RE3                : 1;
    unsigned RE4                : 1;
    unsigned RE5                : 1;
    unsigned RE6                : 1;
    unsigned RE7                : 1;
    };

  struct
    {
    unsigned AD8                : 1;
    unsigned AD9                : 1;
    unsigned AD10               : 1;
    unsigned AD11               : 1;
    unsigned AD12               : 1;
    unsigned AD13               : 1;
    unsigned AD14               : 1;
    unsigned AD15               : 1;
    };

  struct
    {
    unsigned P2D                : 1;
    unsigned P2C                : 1;
    unsigned P2B                : 1;
    unsigned P3C                : 1;
    unsigned P3B                : 1;
    unsigned P1C                : 1;
    unsigned P1B                : 1;
    unsigned P2A                : 1;
    };

  struct
    {
    unsigned NOT_RD             : 1;
    unsigned NOT_WR             : 1;
    unsigned CCP10              : 1;
    unsigned CCP9               : 1;
    unsigned CCP8               : 1;
    unsigned CCP7               : 1;
    unsigned CCP6               : 1;
    unsigned CCP2               : 1;
    };

  struct
    {
    unsigned                    : 1;
    unsigned                    : 1;
    unsigned NOT_CS             : 1;
    unsigned REFO               : 1;
    unsigned                    : 1;
    unsigned                    : 1;
    unsigned                    : 1;
    unsigned                    : 1;
    };
  } __PORTEbits_t;

extern __at(0x0F84) volatile __PORTEbits_t PORTEbits;

#define _PORTE_RE0              0x01
#define _PORTE_AD8              0x01
#define _PORTE_P2D              0x01
#define _PORTE_NOT_RD           0x01
#define _PORTE_RE1              0x02
#define _PORTE_AD9              0x02
#define _PORTE_P2C              0x02
#define _PORTE_NOT_WR           0x02
#define _PORTE_RE2              0x04
#define _PORTE_AD10             0x04
#define _PORTE_P2B              0x04
#define _PORTE_CCP10            0x04
#define _PORTE_NOT_CS           0x04
#define _PORTE_RE3              0x08
#define _PORTE_AD11             0x08
#define _PORTE_P3C              0x08
#define _PORTE_CCP9             0x08
#define _PORTE_REFO             0x08
#define _PORTE_RE4              0x10
#define _PORTE_AD12             0x10
#define _PORTE_P3B              0x10
#define _PORTE_CCP8             0x10
#define _PORTE_RE5              0x20
#define _PORTE_AD13             0x20
#define _PORTE_P1C              0x20
#define _PORTE_CCP7             0x20
#define _PORTE_RE6              0x40
#define _PORTE_AD14             0x40
#define _PORTE_P1B              0x40
#define _PORTE_CCP6             0x40
#define _PORTE_RE7              0x80
#define _PORTE_AD15             0x80
#define _PORTE_P2A              0x80
#define _PORTE_CCP2             0x80

//==============================================================================


//==============================================================================
//        PORTF Bits

extern __at(0x0F85) __sfr PORTF;

typedef union
  {
  struct
    {
    unsigned                    : 1;
    unsigned RF1                : 1;
    unsigned RF2                : 1;
    unsigned RF3                : 1;
    unsigned RF4                : 1;
    unsigned RF5                : 1;
    unsigned RF6                : 1;
    unsigned RF7                : 1;
    };

  struct
    {
    unsigned                    : 1;
    unsigned AN6                : 1;
    unsigned AN7                : 1;
    unsigned AN8                : 1;
    unsigned AN9                : 1;
    unsigned AN10               : 1;
    unsigned AN11               : 1;
    unsigned AN5                : 1;
    };

  struct
    {
    unsigned                    : 1;
    unsigned C2OUT              : 1;
    unsigned C1OUT              : 1;
    unsigned C2INB              : 1;
    unsigned C2INA              : 1;
    unsigned C1INB              : 1;
    unsigned C1INA              : 1;
    unsigned SS1                : 1;
    };

  struct
    {
    unsigned                    : 1;
    unsigned CTDIN              : 1;
    unsigned                    : 1;
    unsigned CTMUI              : 1;
    unsigned                    : 1;
    unsigned CVREF              : 1;
    unsigned                    : 1;
    unsigned                    : 1;
    };
  } __PORTFbits_t;

extern __at(0x0F85) volatile __PORTFbits_t PORTFbits;

#define _RF1                    0x02
#define _AN6                    0x02
#define _C2OUT                  0x02
#define _CTDIN                  0x02
#define _RF2                    0x04
#define _AN7                    0x04
#define _C1OUT                  0x04
#define _RF3                    0x08
#define _AN8                    0x08
#define _C2INB                  0x08
#define _CTMUI                  0x08
#define _RF4                    0x10
#define _AN9                    0x10
#define _C2INA                  0x10
#define _RF5                    0x20
#define _AN10                   0x20
#define _C1INB                  0x20
#define _CVREF                  0x20
#define _RF6                    0x40
#define _AN11                   0x40
#define _C1INA                  0x40
#define _RF7                    0x80
#define _AN5                    0x80
#define _SS1                    0x80

//==============================================================================


//==============================================================================
//        PORTG Bits

extern __at(0x0F86) __sfr PORTG;

typedef union
  {
  struct
    {
    unsigned RG0                : 1;
    unsigned RG1                : 1;
    unsigned RG2                : 1;
    unsigned RG3                : 1;
    unsigned RG4                : 1;
    unsigned RG5                : 1;
    unsigned                    : 1;
    unsigned                    : 1;
    };

  struct
    {
    unsigned CCP3               : 1;
    unsigned C3OUT              : 1;
    unsigned C3INA              : 1;
    unsigned C3INB              : 1;
    unsigned C3INC              : 1;
    unsigned                    : 1;
    unsigned                    : 1;
    unsigned                    : 1;
    };

  struct
    {
    unsigned PA3                : 1;
    unsigned TX2                : 1;
    unsigned RX2                : 1;
    unsigned PD3                : 1;
    unsigned PD1                : 1;
    unsigned                    : 1;
    unsigned                    : 1;
    unsigned                    : 1;
    };

  struct
    {
    unsigned                    : 1;
    unsigned AN19               : 1;
    unsigned AN18               : 1;
    unsigned AN17               : 1;
    unsigned AN16               : 1;
    unsigned                    : 1;
    unsigned                    : 1;
    unsigned                    : 1;
    };

  struct
    {
    unsigned                    : 1;
    unsigned CK2                : 1;
    unsigned DT2                : 1;
    unsigned CCP4               : 1;
    unsigned CCP5               : 1;
    unsigned                    : 1;
    unsigned                    : 1;
    unsigned                    : 1;
    };

  struct
    {
    unsigned                    : 1;
    unsigned                    : 1;
    unsigned                    : 1;
    unsigned                    : 1;
    unsigned T7CKI              : 1;
    unsigned                    : 1;
    unsigned                    : 1;
    unsigned                    : 1;
    };

  struct
    {
    unsigned                    : 1;
    unsigned                    : 1;
    unsigned                    : 1;
    unsigned                    : 1;
    unsigned T5G                : 1;
    unsigned                    : 1;
    unsigned                    : 1;
    unsigned                    : 1;
    };

  struct
    {
    unsigned                    : 1;
    unsigned                    : 1;
    unsigned                    : 1;
    unsigned                    : 1;
    unsigned RTCC               : 1;
    unsigned                    : 1;
    unsigned                    : 1;
    unsigned                    : 1;
    };

  struct
    {
    unsigned RG                 : 6;
    unsigned                    : 2;
    };
  } __PORTGbits_t;

extern __at(0x0F86) volatile __PORTGbits_t PORTGbits;

#define _RG0                    0x01
#define _CCP3                   0x01
#define _PA3                    0x01
#define _RG1                    0x02
#define _C3OUT                  0x02
#define _TX2                    0x02
#define _AN19                   0x02
#define _CK2                    0x02
#define _RG2                    0x04
#define _C3INA                  0x04
#define _RX2                    0x04
#define _AN18                   0x04
#define _DT2                    0x04
#define _RG3                    0x08
#define _C3INB                  0x08
#define _PD3                    0x08
#define _AN17                   0x08
#define _CCP4                   0x08
#define _RG4                    0x10
#define _C3INC                  0x10
#define _PD1                    0x10
#define _AN16                   0x10
#define _CCP5                   0x10
#define _T7CKI                  0x10
#define _T5G                    0x10
#define _RTCC                   0x10
#define _RG5                    0x20

//==============================================================================


//==============================================================================
//        PORTH Bits

extern __at(0x0F87) __sfr PORTH;

typedef union
  {
  struct
    {
    unsigned RH0                : 1;
    unsigned RH1                : 1;
    unsigned RH2                : 1;
    unsigned RH3                : 1;
    unsigned RH4                : 1;
    unsigned RH5                : 1;
    unsigned RH6                : 1;
    unsigned RH7                : 1;
    };

  struct
    {
    unsigned AN23               : 1;
    unsigned AN22               : 1;
    unsigned AN21               : 1;
    unsigned AN20               : 1;
    unsigned AN12               : 1;
    unsigned AN13               : 1;
    unsigned AN14               : 1;
    unsigned AN15               : 1;
    };

  struct
    {
    unsigned A16                : 1;
    unsigned A17                : 1;
    unsigned A18                : 1;
    unsigned A19                : 1;
    unsigned CCP9               : 1;
    unsigned CCP8               : 1;
    unsigned CCP7               : 1;
    unsigned CCP6               : 1;
    };

  struct
    {
    unsigned                    : 1;
    unsigned                    : 1;
    unsigned                    : 1;
    unsigned                    : 1;
    unsigned PC3                : 1;
    unsigned PB3                : 1;
    unsigned PC1                : 1;
    unsigned PB1                : 1;
    };

  struct
    {
    unsigned                    : 1;
    unsigned                    : 1;
    unsigned                    : 1;
    unsigned                    : 1;
    unsigned C2INC              : 1;
    unsigned C2IND              : 1;
    unsigned C1INC              : 1;
    unsigned                    : 1;
    };
  } __PORTHbits_t;

extern __at(0x0F87) volatile __PORTHbits_t PORTHbits;

#define _PORTH_RH0              0x01
#define _PORTH_AN23             0x01
#define _PORTH_A16              0x01
#define _PORTH_RH1              0x02
#define _PORTH_AN22             0x02
#define _PORTH_A17              0x02
#define _PORTH_RH2              0x04
#define _PORTH_AN21             0x04
#define _PORTH_A18              0x04
#define _PORTH_RH3              0x08
#define _PORTH_AN20             0x08
#define _PORTH_A19              0x08
#define _PORTH_RH4              0x10
#define _PORTH_AN12             0x10
#define _PORTH_CCP9             0x10
#define _PORTH_PC3              0x10
#define _PORTH_C2INC            0x10
#define _PORTH_RH5              0x20
#define _PORTH_AN13             0x20
#define _PORTH_CCP8             0x20
#define _PORTH_PB3              0x20
#define _PORTH_C2IND            0x20
#define _PORTH_RH6              0x40
#define _PORTH_AN14             0x40
#define _PORTH_CCP7             0x40
#define _PORTH_PC1              0x40
#define _PORTH_C1INC            0x40
#define _PORTH_RH7              0x80
#define _PORTH_AN15             0x80
#define _PORTH_CCP6             0x80
#define _PORTH_PB1              0x80

//==============================================================================


//==============================================================================
//        PORTJ Bits

extern __at(0x0F88) __sfr PORTJ;

typedef union
  {
  struct
    {
    unsigned RJ0                : 1;
    unsigned RJ1                : 1;
    unsigned RJ2                : 1;
    unsigned RJ3                : 1;
    unsigned RJ4                : 1;
    unsigned RJ5                : 1;
    unsigned RJ6                : 1;
    unsigned RJ7                : 1;
    };

  struct
    {
    unsigned ALE                : 1;
    unsigned OE                 : 1;
    unsigned WRL                : 1;
    unsigned WRH                : 1;
    unsigned BA0                : 1;
    unsigned CE                 : 1;
    unsigned LB                 : 1;
    unsigned UB                 : 1;
    };
  } __PORTJbits_t;

extern __at(0x0F88) volatile __PORTJbits_t PORTJbits;

#define _RJ0                    0x01
#define _ALE                    0x01
#define _RJ1                    0x02
#define _OE                     0x02
#define _RJ2                    0x04
#define _WRL                    0x04
#define _RJ3                    0x08
#define _WRH                    0x08
#define _RJ4                    0x10
#define _BA0                    0x10
#define _RJ5                    0x20
#define _CE                     0x20
#define _RJ6                    0x40
#define _LB                     0x40
#define _RJ7                    0x80
#define _UB                     0x80

//==============================================================================


//==============================================================================
//        LATA Bits

extern __at(0x0F89) __sfr LATA;

typedef struct
  {
  unsigned LATA0                : 1;
  unsigned LATA1                : 1;
  unsigned LATA2                : 1;
  unsigned LATA3                : 1;
  unsigned LATA4                : 1;
  unsigned LATA5                : 1;
  unsigned LATA6                : 1;
  unsigned LATA7                : 1;
  } __LATAbits_t;

extern __at(0x0F89) volatile __LATAbits_t LATAbits;

#define _LATA0                  0x01
#define _LATA1                  0x02
#define _LATA2                  0x04
#define _LATA3                  0x08
#define _LATA4                  0x10
#define _LATA5                  0x20
#define _LATA6                  0x40
#define _LATA7                  0x80

//==============================================================================


//==============================================================================
//        LATB Bits

extern __at(0x0F8A) __sfr LATB;

typedef struct
  {
  unsigned LATB0                : 1;
  unsigned LATB1                : 1;
  unsigned LATB2                : 1;
  unsigned LATB3                : 1;
  unsigned LATB4                : 1;
  unsigned LATB5                : 1;
  unsigned LATB6                : 1;
  unsigned LATB7                : 1;
  } __LATBbits_t;

extern __at(0x0F8A) volatile __LATBbits_t LATBbits;

#define _LATB0                  0x01
#define _LATB1                  0x02
#define _LATB2                  0x04
#define _LATB3                  0x08
#define _LATB4                  0x10
#define _LATB5                  0x20
#define _LATB6                  0x40
#define _LATB7                  0x80

//==============================================================================


//==============================================================================
//        LATC Bits

extern __at(0x0F8B) __sfr LATC;

typedef struct
  {
  unsigned LATC0                : 1;
  unsigned LATC1                : 1;
  unsigned LATC2                : 1;
  unsigned LATC3                : 1;
  unsigned LATC4                : 1;
  unsigned LATC5                : 1;
  unsigned LATC6                : 1;
  unsigned LATC7                : 1;
  } __LATCbits_t;

extern __at(0x0F8B) volatile __LATCbits_t LATCbits;

#define _LATC0                  0x01
#define _LATC1                  0x02
#define _LATC2                  0x04
#define _LATC3                  0x08
#define _LATC4                  0x10
#define _LATC5                  0x20
#define _LATC6                  0x40
#define _LATC7                  0x80

//==============================================================================


//==============================================================================
//        LATD Bits

extern __at(0x0F8C) __sfr LATD;

typedef struct
  {
  unsigned LATD0                : 1;
  unsigned LATD1                : 1;
  unsigned LATD2                : 1;
  unsigned LATD3                : 1;
  unsigned LATD4                : 1;
  unsigned LATD5                : 1;
  unsigned LATD6                : 1;
  unsigned LATD7                : 1;
  } __LATDbits_t;

extern __at(0x0F8C) volatile __LATDbits_t LATDbits;

#define _LATD0                  0x01
#define _LATD1                  0x02
#define _LATD2                  0x04
#define _LATD3                  0x08
#define _LATD4                  0x10
#define _LATD5                  0x20
#define _LATD6                  0x40
#define _LATD7                  0x80

//==============================================================================


//==============================================================================
//        LATE Bits

extern __at(0x0F8D) __sfr LATE;

typedef struct
  {
  unsigned LATE0                : 1;
  unsigned LATE1                : 1;
  unsigned LATE2                : 1;
  unsigned LATE3                : 1;
  unsigned LATE4                : 1;
  unsigned LATE5                : 1;
  unsigned LATE6                : 1;
  unsigned LATE7                : 1;
  } __LATEbits_t;

extern __at(0x0F8D) volatile __LATEbits_t LATEbits;

#define _LATE0                  0x01
#define _LATE1                  0x02
#define _LATE2                  0x04
#define _LATE3                  0x08
#define _LATE4                  0x10
#define _LATE5                  0x20
#define _LATE6                  0x40
#define _LATE7                  0x80

//==============================================================================


//==============================================================================
//        LATF Bits

extern __at(0x0F8E) __sfr LATF;

typedef struct
  {
  unsigned                      : 1;
  unsigned LATF1                : 1;
  unsigned LATF2                : 1;
  unsigned LATF3                : 1;
  unsigned LATF4                : 1;
  unsigned LATF5                : 1;
  unsigned LATF6                : 1;
  unsigned LATF7                : 1;
  } __LATFbits_t;

extern __at(0x0F8E) volatile __LATFbits_t LATFbits;

#define _LATF1                  0x02
#define _LATF2                  0x04
#define _LATF3                  0x08
#define _LATF4                  0x10
#define _LATF5                  0x20
#define _LATF6                  0x40
#define _LATF7                  0x80

//==============================================================================


//==============================================================================
//        LATG Bits

extern __at(0x0F8F) __sfr LATG;

typedef union
  {
  struct
    {
    unsigned LATG0              : 1;
    unsigned LATG1              : 1;
    unsigned LATG2              : 1;
    unsigned LATG3              : 1;
    unsigned LATG4              : 1;
    unsigned                    : 1;
    unsigned                    : 1;
    unsigned                    : 1;
    };

  struct
    {
    unsigned LATG               : 5;
    unsigned                    : 3;
    };
  } __LATGbits_t;

extern __at(0x0F8F) volatile __LATGbits_t LATGbits;

#define _LATG0                  0x01
#define _LATG1                  0x02
#define _LATG2                  0x04
#define _LATG3                  0x08
#define _LATG4                  0x10

//==============================================================================


//==============================================================================
//        LATH Bits

extern __at(0x0F90) __sfr LATH;

typedef struct
  {
  unsigned LATH0                : 1;
  unsigned LATH1                : 1;
  unsigned LATH2                : 1;
  unsigned LATH3                : 1;
  unsigned LATH4                : 1;
  unsigned LATH5                : 1;
  unsigned LATH6                : 1;
  unsigned LATH7                : 1;
  } __LATHbits_t;

extern __at(0x0F90) volatile __LATHbits_t LATHbits;

#define _LATH0                  0x01
#define _LATH1                  0x02
#define _LATH2                  0x04
#define _LATH3                  0x08
#define _LATH4                  0x10
#define _LATH5                  0x20
#define _LATH6                  0x40
#define _LATH7                  0x80

//==============================================================================


//==============================================================================
//        LATJ Bits

extern __at(0x0F91) __sfr LATJ;

typedef struct
  {
  unsigned LATJ0                : 1;
  unsigned LATJ1                : 1;
  unsigned LATJ2                : 1;
  unsigned LATJ3                : 1;
  unsigned LATJ4                : 1;
  unsigned LATJ5                : 1;
  unsigned LATJ6                : 1;
  unsigned LATJ7                : 1;
  } __LATJbits_t;

extern __at(0x0F91) volatile __LATJbits_t LATJbits;

#define _LATJ0                  0x01
#define _LATJ1                  0x02
#define _LATJ2                  0x04
#define _LATJ3                  0x08
#define _LATJ4                  0x10
#define _LATJ5                  0x20
#define _LATJ6                  0x40
#define _LATJ7                  0x80

//==============================================================================


//==============================================================================
//        TRISA Bits

extern __at(0x0F92) __sfr TRISA;

typedef struct
  {
  unsigned TRISA0               : 1;
  unsigned TRISA1               : 1;
  unsigned TRISA2               : 1;
  unsigned TRISA3               : 1;
  unsigned TRISA4               : 1;
  unsigned TRISA5               : 1;
  unsigned TRISA6               : 1;
  unsigned TRISA7               : 1;
  } __TRISAbits_t;

extern __at(0x0F92) volatile __TRISAbits_t TRISAbits;

#define _TRISA0                 0x01
#define _TRISA1                 0x02
#define _TRISA2                 0x04
#define _TRISA3                 0x08
#define _TRISA4                 0x10
#define _TRISA5                 0x20
#define _TRISA6                 0x40
#define _TRISA7                 0x80

//==============================================================================


//==============================================================================
//        TRISB Bits

extern __at(0x0F93) __sfr TRISB;

typedef struct
  {
  unsigned TRISB0               : 1;
  unsigned TRISB1               : 1;
  unsigned TRISB2               : 1;
  unsigned TRISB3               : 1;
  unsigned TRISB4               : 1;
  unsigned TRISB5               : 1;
  unsigned TRISB6               : 1;
  unsigned TRISB7               : 1;
  } __TRISBbits_t;

extern __at(0x0F93) volatile __TRISBbits_t TRISBbits;

#define _TRISB0                 0x01
#define _TRISB1                 0x02
#define _TRISB2                 0x04
#define _TRISB3                 0x08
#define _TRISB4                 0x10
#define _TRISB5                 0x20
#define _TRISB6                 0x40
#define _TRISB7                 0x80

//==============================================================================


//==============================================================================
//        TRISC Bits

extern __at(0x0F94) __sfr TRISC;

typedef struct
  {
  unsigned TRISC0               : 1;
  unsigned TRISC1               : 1;
  unsigned TRISC2               : 1;
  unsigned TRISC3               : 1;
  unsigned TRISC4               : 1;
  unsigned TRISC5               : 1;
  unsigned TRISC6               : 1;
  unsigned TRISC7               : 1;
  } __TRISCbits_t;

extern __at(0x0F94) volatile __TRISCbits_t TRISCbits;

#define _TRISC0                 0x01
#define _TRISC1                 0x02
#define _TRISC2                 0x04
#define _TRISC3                 0x08
#define _TRISC4                 0x10
#define _TRISC5                 0x20
#define _TRISC6                 0x40
#define _TRISC7                 0x80

//==============================================================================


//==============================================================================
//        TRISD Bits

extern __at(0x0F95) __sfr TRISD;

typedef struct
  {
  unsigned TRISD0               : 1;
  unsigned TRISD1               : 1;
  unsigned TRISD2               : 1;
  unsigned TRISD3               : 1;
  unsigned TRISD4               : 1;
  unsigned TRISD5               : 1;
  unsigned TRISD6               : 1;
  unsigned TRISD7               : 1;
  } __TRISDbits_t;

extern __at(0x0F95) volatile __TRISDbits_t TRISDbits;

#define _TRISD0                 0x01
#define _TRISD1                 0x02
#define _TRISD2                 0x04
#define _TRISD3                 0x08
#define _TRISD4                 0x10
#define _TRISD5                 0x20
#define _TRISD6                 0x40
#define _TRISD7                 0x80

//==============================================================================


//==============================================================================
//        TRISE Bits

extern __at(0x0F96) __sfr TRISE;

typedef struct
  {
  unsigned TRISE0               : 1;
  unsigned TRISE1               : 1;
  unsigned TRISE2               : 1;
  unsigned TRISE3               : 1;
  unsigned TRISE4               : 1;
  unsigned TRISE5               : 1;
  unsigned TRISE6               : 1;
  unsigned TRISE7               : 1;
  } __TRISEbits_t;

extern __at(0x0F96) volatile __TRISEbits_t TRISEbits;

#define _TRISE0                 0x01
#define _TRISE1                 0x02
#define _TRISE2                 0x04
#define _TRISE3                 0x08
#define _TRISE4                 0x10
#define _TRISE5                 0x20
#define _TRISE6                 0x40
#define _TRISE7                 0x80

//==============================================================================


//==============================================================================
//        TRISF Bits

extern __at(0x0F97) __sfr TRISF;

typedef struct
  {
  unsigned                      : 1;
  unsigned TRISF1               : 1;
  unsigned TRISF2               : 1;
  unsigned TRISF3               : 1;
  unsigned TRISF4               : 1;
  unsigned TRISF5               : 1;
  unsigned TRISF6               : 1;
  unsigned TRISF7               : 1;
  } __TRISFbits_t;

extern __at(0x0F97) volatile __TRISFbits_t TRISFbits;

#define _TRISF1                 0x02
#define _TRISF2                 0x04
#define _TRISF3                 0x08
#define _TRISF4                 0x10
#define _TRISF5                 0x20
#define _TRISF6                 0x40
#define _TRISF7                 0x80

//==============================================================================


//==============================================================================
//        TRISG Bits

extern __at(0x0F98) __sfr TRISG;

typedef union
  {
  struct
    {
    unsigned TRISG0             : 1;
    unsigned TRISG1             : 1;
    unsigned TRISG2             : 1;
    unsigned TRISG3             : 1;
    unsigned TRISG4             : 1;
    unsigned                    : 1;
    unsigned                    : 1;
    unsigned                    : 1;
    };

  struct
    {
    unsigned TRISG              : 5;
    unsigned                    : 3;
    };
  } __TRISGbits_t;

extern __at(0x0F98) volatile __TRISGbits_t TRISGbits;

#define _TRISG0                 0x01
#define _TRISG1                 0x02
#define _TRISG2                 0x04
#define _TRISG3                 0x08
#define _TRISG4                 0x10

//==============================================================================


//==============================================================================
//        TRISH Bits

extern __at(0x0F99) __sfr TRISH;

typedef struct
  {
  unsigned TRISH0               : 1;
  unsigned TRISH1               : 1;
  unsigned TRISH2               : 1;
  unsigned TRISH3               : 1;
  unsigned TRISH4               : 1;
  unsigned TRISH5               : 1;
  unsigned TRISH6               : 1;
  unsigned TRISH7               : 1;
  } __TRISHbits_t;

extern __at(0x0F99) volatile __TRISHbits_t TRISHbits;

#define _TRISH0                 0x01
#define _TRISH1                 0x02
#define _TRISH2                 0x04
#define _TRISH3                 0x08
#define _TRISH4                 0x10
#define _TRISH5                 0x20
#define _TRISH6                 0x40
#define _TRISH7                 0x80

//==============================================================================


//==============================================================================
//        TRISJ Bits

extern __at(0x0F9A) __sfr TRISJ;

typedef struct
  {
  unsigned TRISJ0               : 1;
  unsigned TRISJ1               : 1;
  unsigned TRISJ2               : 1;
  unsigned TRISJ3               : 1;
  unsigned TRISJ4               : 1;
  unsigned TRISJ5               : 1;
  unsigned TRISJ6               : 1;
  unsigned TRISJ7               : 1;
  } __TRISJbits_t;

extern __at(0x0F9A) volatile __TRISJbits_t TRISJbits;

#define _TRISJ0                 0x01
#define _TRISJ1                 0x02
#define _TRISJ2                 0x04
#define _TRISJ3                 0x08
#define _TRISJ4                 0x10
#define _TRISJ5                 0x20
#define _TRISJ6                 0x40
#define _TRISJ7                 0x80

//==============================================================================


//==============================================================================
//        OSCTUNE Bits

extern __at(0x0F9B) __sfr OSCTUNE;

typedef union
  {
  struct
    {
    unsigned TUN0               : 1;
    unsigned TUN1               : 1;
    unsigned TUN2               : 1;
    unsigned TUN3               : 1;
    unsigned TUN4               : 1;
    unsigned TUN5               : 1;
    unsigned PLLEN              : 1;
    unsigned INTSRC             : 1;
    };

  struct
    {
    unsigned TUN                : 6;
    unsigned                    : 2;
    };
  } __OSCTUNEbits_t;

extern __at(0x0F9B) volatile __OSCTUNEbits_t OSCTUNEbits;

#define _TUN0                   0x01
#define _TUN1                   0x02
#define _TUN2                   0x04
#define _TUN3                   0x08
#define _TUN4                   0x10
#define _TUN5                   0x20
#define _PLLEN                  0x40
#define _INTSRC                 0x80

//==============================================================================


//==============================================================================
//        PSTR1CON Bits

extern __at(0x0F9C) __sfr PSTR1CON;

typedef union
  {
  struct
    {
    unsigned STRA               : 1;
    unsigned STRB               : 1;
    unsigned STRC               : 1;
    unsigned STRD               : 1;
    unsigned STRSYNC            : 1;
    unsigned                    : 1;
    unsigned CMPL0              : 1;
    unsigned CMPL1              : 1;
    };

  struct
    {
    unsigned                    : 6;
    unsigned CMPL               : 2;
    };
  } __PSTR1CONbits_t;

extern __at(0x0F9C) volatile __PSTR1CONbits_t PSTR1CONbits;

#define _STRA                   0x01
#define _STRB                   0x02
#define _STRC                   0x04
#define _STRD                   0x08
#define _STRSYNC                0x10
#define _CMPL0                  0x40
#define _CMPL1                  0x80

//==============================================================================


//==============================================================================
//        PIE1 Bits

extern __at(0x0F9D) __sfr PIE1;

typedef union
  {
  struct
    {
    unsigned TMR1IE             : 1;
    unsigned TMR2IE             : 1;
    unsigned TMR1GIE            : 1;
    unsigned SSP1IE             : 1;
    unsigned TX1IE              : 1;
    unsigned RC1IE              : 1;
    unsigned ADIE               : 1;
    unsigned PSPIE              : 1;
    };

  struct
    {
    unsigned                    : 1;
    unsigned                    : 1;
    unsigned                    : 1;
    unsigned SSPIE              : 1;
    unsigned TXIE               : 1;
    unsigned RCIE               : 1;
    unsigned                    : 1;
    unsigned                    : 1;
    };
  } __PIE1bits_t;

extern __at(0x0F9D) volatile __PIE1bits_t PIE1bits;

#define _TMR1IE                 0x01
#define _TMR2IE                 0x02
#define _TMR1GIE                0x04
#define _SSP1IE                 0x08
#define _SSPIE                  0x08
#define _TX1IE                  0x10
#define _TXIE                   0x10
#define _RC1IE                  0x20
#define _RCIE                   0x20
#define _ADIE                   0x40
#define _PSPIE                  0x80

//==============================================================================


//==============================================================================
//        PIR1 Bits

extern __at(0x0F9E) __sfr PIR1;

typedef union
  {
  struct
    {
    unsigned TMR1IF             : 1;
    unsigned TMR2IF             : 1;
    unsigned TMR1GIF            : 1;
    unsigned SSP1IF             : 1;
    unsigned TX1IF              : 1;
    unsigned RC1IF              : 1;
    unsigned ADIF               : 1;
    unsigned PSPIF              : 1;
    };

  struct
    {
    unsigned                    : 1;
    unsigned                    : 1;
    unsigned                    : 1;
    unsigned SSPIF              : 1;
    unsigned TXIF               : 1;
    unsigned RCIF               : 1;
    unsigned                    : 1;
    unsigned                    : 1;
    };
  } __PIR1bits_t;

extern __at(0x0F9E) volatile __PIR1bits_t PIR1bits;

#define _TMR1IF                 0x01
#define _TMR2IF                 0x02
#define _TMR1GIF                0x04
#define _SSP1IF                 0x08
#define _SSPIF                  0x08
#define _TX1IF                  0x10
#define _TXIF                   0x10
#define _RC1IF                  0x20
#define _RCIF                   0x20
#define _ADIF                   0x40
#define _PSPIF                  0x80

//==============================================================================


//==============================================================================
//        IPR1 Bits

extern __at(0x0F9F) __sfr IPR1;

typedef union
  {
  struct
    {
    unsigned TMR1IP             : 1;
    unsigned TMR2IP             : 1;
    unsigned TMR1GIP            : 1;
    unsigned SSP1IP             : 1;
    unsigned TX1IP              : 1;
    unsigned RC1IP              : 1;
    unsigned ADIP               : 1;
    unsigned PSPIP              : 1;
    };

  struct
    {
    unsigned                    : 1;
    unsigned                    : 1;
    unsigned                    : 1;
    unsigned SSPIP              : 1;
    unsigned TXIP               : 1;
    unsigned RCIP               : 1;
    unsigned                    : 1;
    unsigned                    : 1;
    };
  } __IPR1bits_t;

extern __at(0x0F9F) volatile __IPR1bits_t IPR1bits;

#define _TMR1IP                 0x01
#define _TMR2IP                 0x02
#define _TMR1GIP                0x04
#define _SSP1IP                 0x08
#define _SSPIP                  0x08
#define _TX1IP                  0x10
#define _TXIP                   0x10
#define _RC1IP                  0x20
#define _RCIP                   0x20
#define _ADIP                   0x40
#define _PSPIP                  0x80

//==============================================================================


//==============================================================================
//        PIE2 Bits

extern __at(0x0FA0) __sfr PIE2;

typedef union
  {
  struct
    {
    unsigned TMR3GIE            : 1;
    unsigned TMR3IE             : 1;
    unsigned HLVDIE             : 1;
    unsigned BCL1IE             : 1;
    unsigned BCL2IE             : 1;
    unsigned SSP2IE             : 1;
    unsigned                    : 1;
    unsigned OSCFIE             : 1;
    };

  struct
    {
    unsigned                    : 1;
    unsigned                    : 1;
    unsigned LVDIE              : 1;
    unsigned BCLIE              : 1;
    unsigned                    : 1;
    unsigned                    : 1;
    unsigned                    : 1;
    unsigned                    : 1;
    };
  } __PIE2bits_t;

extern __at(0x0FA0) volatile __PIE2bits_t PIE2bits;

#define _TMR3GIE                0x01
#define _TMR3IE                 0x02
#define _HLVDIE                 0x04
#define _LVDIE                  0x04
#define _BCL1IE                 0x08
#define _BCLIE                  0x08
#define _BCL2IE                 0x10
#define _SSP2IE                 0x20
#define _OSCFIE                 0x80

//==============================================================================


//==============================================================================
//        PIR2 Bits

extern __at(0x0FA1) __sfr PIR2;

typedef union
  {
  struct
    {
    unsigned TMR3GIF            : 1;
    unsigned TMR3IF             : 1;
    unsigned HLVDIF             : 1;
    unsigned BCL1IF             : 1;
    unsigned BCL2IF             : 1;
    unsigned SSP2IF             : 1;
    unsigned                    : 1;
    unsigned OSCFIF             : 1;
    };

  struct
    {
    unsigned                    : 1;
    unsigned                    : 1;
    unsigned LVDIF              : 1;
    unsigned BCLIF              : 1;
    unsigned                    : 1;
    unsigned                    : 1;
    unsigned                    : 1;
    unsigned                    : 1;
    };
  } __PIR2bits_t;

extern __at(0x0FA1) volatile __PIR2bits_t PIR2bits;

#define _TMR3GIF                0x01
#define _TMR3IF                 0x02
#define _HLVDIF                 0x04
#define _LVDIF                  0x04
#define _BCL1IF                 0x08
#define _BCLIF                  0x08
#define _BCL2IF                 0x10
#define _SSP2IF                 0x20
#define _OSCFIF                 0x80

//==============================================================================


//==============================================================================
//        IPR2 Bits

extern __at(0x0FA2) __sfr IPR2;

typedef union
  {
  struct
    {
    unsigned TMR3GIP            : 1;
    unsigned TMR3IP             : 1;
    unsigned HLVDIP             : 1;
    unsigned BCL1IP             : 1;
    unsigned BCL2IP             : 1;
    unsigned SSP2IP             : 1;
    unsigned                    : 1;
    unsigned OSCFIP             : 1;
    };

  struct
    {
    unsigned                    : 1;
    unsigned                    : 1;
    unsigned LVDIP              : 1;
    unsigned BCLIP              : 1;
    unsigned                    : 1;
    unsigned                    : 1;
    unsigned                    : 1;
    unsigned                    : 1;
    };
  } __IPR2bits_t;

extern __at(0x0FA2) volatile __IPR2bits_t IPR2bits;

#define _TMR3GIP                0x01
#define _TMR3IP                 0x02
#define _HLVDIP                 0x04
#define _LVDIP                  0x04
#define _BCL1IP                 0x08
#define _BCLIP                  0x08
#define _BCL2IP                 0x10
#define _SSP2IP                 0x20
#define _OSCFIP                 0x80

//==============================================================================


//==============================================================================
//        PIE3 Bits

extern __at(0x0FA3) __sfr PIE3;

typedef struct
  {
  unsigned RTCCIE               : 1;
  unsigned CCP1IE               : 1;
  unsigned CCP2IE               : 1;
  unsigned CTMUIE               : 1;
  unsigned TX2IE                : 1;
  unsigned RC2IE                : 1;
  unsigned                      : 1;
  unsigned TMR5GIE              : 1;
  } __PIE3bits_t;

extern __at(0x0FA3) volatile __PIE3bits_t PIE3bits;

#define _RTCCIE                 0x01
#define _CCP1IE                 0x02
#define _CCP2IE                 0x04
#define _CTMUIE                 0x08
#define _TX2IE                  0x10
#define _RC2IE                  0x20
#define _TMR5GIE                0x80

//==============================================================================


//==============================================================================
//        PIR3 Bits

extern __at(0x0FA4) __sfr PIR3;

typedef struct
  {
  unsigned RTCCIF               : 1;
  unsigned CCP1IF               : 1;
  unsigned CCP2IF               : 1;
  unsigned CTMUIF               : 1;
  unsigned TX2IF                : 1;
  unsigned RC2IF                : 1;
  unsigned                      : 1;
  unsigned TMR5GIF              : 1;
  } __PIR3bits_t;

extern __at(0x0FA4) volatile __PIR3bits_t PIR3bits;

#define _RTCCIF                 0x01
#define _CCP1IF                 0x02
#define _CCP2IF                 0x04
#define _CTMUIF                 0x08
#define _TX2IF                  0x10
#define _RC2IF                  0x20
#define _TMR5GIF                0x80

//==============================================================================


//==============================================================================
//        IPR3 Bits

extern __at(0x0FA5) __sfr IPR3;

typedef struct
  {
  unsigned RTCCIP               : 1;
  unsigned CCP1IP               : 1;
  unsigned CCP2IP               : 1;
  unsigned CTMUIP               : 1;
  unsigned TX2IP                : 1;
  unsigned RC2IP                : 1;
  unsigned                      : 1;
  unsigned TMR5GIP              : 1;
  } __IPR3bits_t;

extern __at(0x0FA5) volatile __IPR3bits_t IPR3bits;

#define _RTCCIP                 0x01
#define _CCP1IP                 0x02
#define _CCP2IP                 0x04
#define _CTMUIP                 0x08
#define _TX2IP                  0x10
#define _RC2IP                  0x20
#define _TMR5GIP                0x80

//==============================================================================


//==============================================================================
//        PIR6 Bits

extern __at(0x0FA6) __sfr PIR6;

typedef struct
  {
  unsigned CMP1IF               : 1;
  unsigned CMP2IF               : 1;
  unsigned CMP3IF               : 1;
  unsigned                      : 1;
  unsigned EEIF                 : 1;
  unsigned                      : 1;
  unsigned                      : 1;
  unsigned                      : 1;
  } __PIR6bits_t;

extern __at(0x0FA6) volatile __PIR6bits_t PIR6bits;

#define _CMP1IF                 0x01
#define _CMP2IF                 0x02
#define _CMP3IF                 0x04
#define _EEIF                   0x10

//==============================================================================


//==============================================================================
//        PSPCON Bits

extern __at(0x0FA7) __sfr PSPCON;

typedef struct
  {
  unsigned                      : 1;
  unsigned                      : 1;
  unsigned                      : 1;
  unsigned                      : 1;
  unsigned PSPMODE              : 1;
  unsigned IBOV                 : 1;
  unsigned OBF                  : 1;
  unsigned IBF                  : 1;
  } __PSPCONbits_t;

extern __at(0x0FA7) volatile __PSPCONbits_t PSPCONbits;

#define _PSPMODE                0x10
#define _IBOV                   0x20
#define _OBF                    0x40
#define _IBF                    0x80

//==============================================================================


//==============================================================================
//        HLVDCON Bits

extern __at(0x0FA8) __sfr HLVDCON;

typedef union
  {
  struct
    {
    unsigned HLVDL0             : 1;
    unsigned HLVDL1             : 1;
    unsigned HLVDL2             : 1;
    unsigned HLVDL3             : 1;
    unsigned HLVDEN             : 1;
    unsigned IRVST              : 1;
    unsigned BGVST              : 1;
    unsigned VDIRMAG            : 1;
    };

  struct
    {
    unsigned HLVDL              : 4;
    unsigned                    : 4;
    };
  } __HLVDCONbits_t;

extern __at(0x0FA8) volatile __HLVDCONbits_t HLVDCONbits;

#define _HLVDL0                 0x01
#define _HLVDL1                 0x02
#define _HLVDL2                 0x04
#define _HLVDL3                 0x08
#define _HLVDEN                 0x10
#define _IRVST                  0x20
#define _BGVST                  0x40
#define _VDIRMAG                0x80

//==============================================================================


//==============================================================================
//        IPR6 Bits

extern __at(0x0FA9) __sfr IPR6;

typedef struct
  {
  unsigned CMP1IP               : 1;
  unsigned CMP2IP               : 1;
  unsigned CMP3IP               : 1;
  unsigned                      : 1;
  unsigned EEIP                 : 1;
  unsigned                      : 1;
  unsigned                      : 1;
  unsigned                      : 1;
  } __IPR6bits_t;

extern __at(0x0FA9) volatile __IPR6bits_t IPR6bits;

#define _CMP1IP                 0x01
#define _CMP2IP                 0x02
#define _CMP3IP                 0x04
#define _EEIP                   0x10

//==============================================================================


//==============================================================================
//        T1GCON Bits

extern __at(0x0FAA) __sfr T1GCON;

typedef union
  {
  struct
    {
    unsigned T1GSS0             : 1;
    unsigned T1GSS1             : 1;
    unsigned T1GVAL             : 1;
    unsigned T1GGO_NOT_T1DONE   : 1;
    unsigned T1GSPM             : 1;
    unsigned T1GTM              : 1;
    unsigned T1GPOL             : 1;
    unsigned TMR1GE             : 1;
    };

  struct
    {
    unsigned                    : 1;
    unsigned                    : 1;
    unsigned                    : 1;
    unsigned T1GGO              : 1;
    unsigned                    : 1;
    unsigned                    : 1;
    unsigned                    : 1;
    unsigned                    : 1;
    };

  struct
    {
    unsigned                    : 1;
    unsigned                    : 1;
    unsigned                    : 1;
    unsigned NOT_T1DONE         : 1;
    unsigned                    : 1;
    unsigned                    : 1;
    unsigned                    : 1;
    unsigned                    : 1;
    };

  struct
    {
    unsigned T1GSS              : 2;
    unsigned                    : 6;
    };
  } __T1GCONbits_t;

extern __at(0x0FAA) volatile __T1GCONbits_t T1GCONbits;

#define _T1GSS0                 0x01
#define _T1GSS1                 0x02
#define _T1GVAL                 0x04
#define _T1GGO_NOT_T1DONE       0x08
#define _T1GGO                  0x08
#define _NOT_T1DONE             0x08
#define _T1GSPM                 0x10
#define _T1GTM                  0x20
#define _T1GPOL                 0x40
#define _TMR1GE                 0x80

//==============================================================================


//==============================================================================
//        RCSTA Bits

extern __at(0x0FAB) __sfr RCSTA;

typedef union
  {
  struct
    {
    unsigned RX9D               : 1;
    unsigned OERR               : 1;
    unsigned FERR               : 1;
    unsigned ADDEN              : 1;
    unsigned CREN               : 1;
    unsigned SREN               : 1;
    unsigned RX9                : 1;
    unsigned SPEN               : 1;
    };

  struct
    {
    unsigned RCD8               : 1;
    unsigned OERR1              : 1;
    unsigned FERR1              : 1;
    unsigned ADEN               : 1;
    unsigned CREN1              : 1;
    unsigned SREN1              : 1;
    unsigned RC9                : 1;
    unsigned SPEN1              : 1;
    };

  struct
    {
    unsigned RX9D1              : 1;
    unsigned                    : 1;
    unsigned                    : 1;
    unsigned ADDEN1             : 1;
    unsigned                    : 1;
    unsigned                    : 1;
    unsigned NOT_RC8            : 1;
    unsigned                    : 1;
    };

  struct
    {
    unsigned                    : 1;
    unsigned                    : 1;
    unsigned                    : 1;
    unsigned                    : 1;
    unsigned                    : 1;
    unsigned                    : 1;
    unsigned RC8_9              : 1;
    unsigned                    : 1;
    };

  struct
    {
    unsigned                    : 1;
    unsigned                    : 1;
    unsigned                    : 1;
    unsigned                    : 1;
    unsigned                    : 1;
    unsigned                    : 1;
    unsigned RX91               : 1;
    unsigned                    : 1;
    };
  } __RCSTAbits_t;

extern __at(0x0FAB) volatile __RCSTAbits_t RCSTAbits;

#define _RX9D                   0x01
#define _RCD8                   0x01
#define _RX9D1                  0x01
#define _OERR                   0x02
#define _OERR1                  0x02
#define _FERR                   0x04
#define _FERR1                  0x04
#define _ADDEN                  0x08
#define _ADEN                   0x08
#define _ADDEN1                 0x08
#define _CREN                   0x10
#define _CREN1                  0x10
#define _SREN                   0x20
#define _SREN1                  0x20
#define _RX9                    0x40
#define _RC9                    0x40
#define _NOT_RC8                0x40
#define _RC8_9                  0x40
#define _RX91                   0x40
#define _SPEN                   0x80
#define _SPEN1                  0x80

//==============================================================================


//==============================================================================
//        RCSTA1 Bits

extern __at(0x0FAB) __sfr RCSTA1;

typedef union
  {
  struct
    {
    unsigned RX9D               : 1;
    unsigned OERR               : 1;
    unsigned FERR               : 1;
    unsigned ADDEN              : 1;
    unsigned CREN               : 1;
    unsigned SREN               : 1;
    unsigned RX9                : 1;
    unsigned SPEN               : 1;
    };

  struct
    {
    unsigned RCD8               : 1;
    unsigned OERR1              : 1;
    unsigned FERR1              : 1;
    unsigned ADEN               : 1;
    unsigned CREN1              : 1;
    unsigned SREN1              : 1;
    unsigned RC9                : 1;
    unsigned SPEN1              : 1;
    };

  struct
    {
    unsigned RX9D1              : 1;
    unsigned                    : 1;
    unsigned                    : 1;
    unsigned ADDEN1             : 1;
    unsigned                    : 1;
    unsigned                    : 1;
    unsigned NOT_RC8            : 1;
    unsigned                    : 1;
    };

  struct
    {
    unsigned                    : 1;
    unsigned                    : 1;
    unsigned                    : 1;
    unsigned                    : 1;
    unsigned                    : 1;
    unsigned                    : 1;
    unsigned RC8_9              : 1;
    unsigned                    : 1;
    };

  struct
    {
    unsigned                    : 1;
    unsigned                    : 1;
    unsigned                    : 1;
    unsigned                    : 1;
    unsigned                    : 1;
    unsigned                    : 1;
    unsigned RX91               : 1;
    unsigned                    : 1;
    };
  } __RCSTA1bits_t;

extern __at(0x0FAB) volatile __RCSTA1bits_t RCSTA1bits;

#define _RCSTA1_RX9D            0x01
#define _RCSTA1_RCD8            0x01
#define _RCSTA1_RX9D1           0x01
#define _RCSTA1_OERR            0x02
#define _RCSTA1_OERR1           0x02
#define _RCSTA1_FERR            0x04
#define _RCSTA1_FERR1           0x04
#define _RCSTA1_ADDEN           0x08
#define _RCSTA1_ADEN            0x08
#define _RCSTA1_ADDEN1          0x08
#define _RCSTA1_CREN            0x10
#define _RCSTA1_CREN1           0x10
#define _RCSTA1_SREN            0x20
#define _RCSTA1_SREN1           0x20
#define _RCSTA1_RX9             0x40
#define _RCSTA1_RC9             0x40
#define _RCSTA1_NOT_RC8         0x40
#define _RCSTA1_RC8_9           0x40
#define _RCSTA1_RX91            0x40
#define _RCSTA1_SPEN            0x80
#define _RCSTA1_SPEN1           0x80

//==============================================================================


//==============================================================================
//        TXSTA Bits

extern __at(0x0FAC) __sfr TXSTA;

typedef union
  {
  struct
    {
    unsigned TX9D               : 1;
    unsigned TRMT               : 1;
    unsigned BRGH               : 1;
    unsigned SENDB              : 1;
    unsigned SYNC               : 1;
    unsigned TXEN               : 1;
    unsigned TX9                : 1;
    unsigned CSRC               : 1;
    };

  struct
    {
    unsigned TXD8               : 1;
    unsigned TRMT1              : 1;
    unsigned BRGH1              : 1;
    unsigned SENDB1             : 1;
    unsigned SYNC1              : 1;
    unsigned TXEN1              : 1;
    unsigned TX8_9              : 1;
    unsigned CSRC1              : 1;
    };

  struct
    {
    unsigned TX9D1              : 1;
    unsigned                    : 1;
    unsigned                    : 1;
    unsigned                    : 1;
    unsigned                    : 1;
    unsigned                    : 1;
    unsigned NOT_TX8            : 1;
    unsigned                    : 1;
    };

  struct
    {
    unsigned                    : 1;
    unsigned                    : 1;
    unsigned                    : 1;
    unsigned                    : 1;
    unsigned                    : 1;
    unsigned                    : 1;
    unsigned TX91               : 1;
    unsigned                    : 1;
    };
  } __TXSTAbits_t;

extern __at(0x0FAC) volatile __TXSTAbits_t TXSTAbits;

#define _TX9D                   0x01
#define _TXD8                   0x01
#define _TX9D1                  0x01
#define _TRMT                   0x02
#define _TRMT1                  0x02
#define _BRGH                   0x04
#define _BRGH1                  0x04
#define _SENDB                  0x08
#define _SENDB1                 0x08
#define _SYNC                   0x10
#define _SYNC1                  0x10
#define _TXEN                   0x20
#define _TXEN1                  0x20
#define _TX9                    0x40
#define _TX8_9                  0x40
#define _NOT_TX8                0x40
#define _TX91                   0x40
#define _CSRC                   0x80
#define _CSRC1                  0x80

//==============================================================================


//==============================================================================
//        TXSTA1 Bits

extern __at(0x0FAC) __sfr TXSTA1;

typedef union
  {
  struct
    {
    unsigned TX9D               : 1;
    unsigned TRMT               : 1;
    unsigned BRGH               : 1;
    unsigned SENDB              : 1;
    unsigned SYNC               : 1;
    unsigned TXEN               : 1;
    unsigned TX9                : 1;
    unsigned CSRC               : 1;
    };

  struct
    {
    unsigned TXD8               : 1;
    unsigned TRMT1              : 1;
    unsigned BRGH1              : 1;
    unsigned SENDB1             : 1;
    unsigned SYNC1              : 1;
    unsigned TXEN1              : 1;
    unsigned TX8_9              : 1;
    unsigned CSRC1              : 1;
    };

  struct
    {
    unsigned TX9D1              : 1;
    unsigned                    : 1;
    unsigned                    : 1;
    unsigned                    : 1;
    unsigned                    : 1;
    unsigned                    : 1;
    unsigned NOT_TX8            : 1;
    unsigned                    : 1;
    };

  struct
    {
    unsigned                    : 1;
    unsigned                    : 1;
    unsigned                    : 1;
    unsigned                    : 1;
    unsigned                    : 1;
    unsigned                    : 1;
    unsigned TX91               : 1;
    unsigned                    : 1;
    };
  } __TXSTA1bits_t;

extern __at(0x0FAC) volatile __TXSTA1bits_t TXSTA1bits;

#define _TXSTA1_TX9D            0x01
#define _TXSTA1_TXD8            0x01
#define _TXSTA1_TX9D1           0x01
#define _TXSTA1_TRMT            0x02
#define _TXSTA1_TRMT1           0x02
#define _TXSTA1_BRGH            0x04
#define _TXSTA1_BRGH1           0x04
#define _TXSTA1_SENDB           0x08
#define _TXSTA1_SENDB1          0x08
#define _TXSTA1_SYNC            0x10
#define _TXSTA1_SYNC1           0x10
#define _TXSTA1_TXEN            0x20
#define _TXSTA1_TXEN1           0x20
#define _TXSTA1_TX9             0x40
#define _TXSTA1_TX8_9           0x40
#define _TXSTA1_NOT_TX8         0x40
#define _TXSTA1_TX91            0x40
#define _TXSTA1_CSRC            0x80
#define _TXSTA1_CSRC1           0x80

//==============================================================================

extern __at(0x0FAD) __sfr TXREG;
extern __at(0x0FAD) __sfr TXREG1;
extern __at(0x0FAE) __sfr RCREG;
extern __at(0x0FAE) __sfr RCREG1;
extern __at(0x0FAF) __sfr SPBRG;
extern __at(0x0FAF) __sfr SPBRG1;

//==============================================================================
//        T3GCON Bits

extern __at(0x0FB0) __sfr T3GCON;

typedef union
  {
  struct
    {
    unsigned T3GSS0             : 1;
    unsigned T3GSS1             : 1;
    unsigned T3GVAL             : 1;
    unsigned T3GGO_NOT_T3DONE   : 1;
    unsigned T3GSPM             : 1;
    unsigned T3GTM              : 1;
    unsigned T3GPOL             : 1;
    unsigned TMR3GE             : 1;
    };

  struct
    {
    unsigned                    : 1;
    unsigned                    : 1;
    unsigned                    : 1;
    unsigned T3GGO              : 1;
    unsigned                    : 1;
    unsigned                    : 1;
    unsigned                    : 1;
    unsigned                    : 1;
    };

  struct
    {
    unsigned                    : 1;
    unsigned                    : 1;
    unsigned                    : 1;
    unsigned NOT_T3DONE         : 1;
    unsigned                    : 1;
    unsigned                    : 1;
    unsigned                    : 1;
    unsigned                    : 1;
    };

  struct
    {
    unsigned T3GSS              : 2;
    unsigned                    : 6;
    };
  } __T3GCONbits_t;

extern __at(0x0FB0) volatile __T3GCONbits_t T3GCONbits;

#define _T3GSS0                 0x01
#define _T3GSS1                 0x02
#define _T3GVAL                 0x04
#define _T3GGO_NOT_T3DONE       0x08
#define _T3GGO                  0x08
#define _NOT_T3DONE             0x08
#define _T3GSPM                 0x10
#define _T3GTM                  0x20
#define _T3GPOL                 0x40
#define _TMR3GE                 0x80

//==============================================================================


//==============================================================================
//        T3CON Bits

extern __at(0x0FB1) __sfr T3CON;

typedef union
  {
  struct
    {
    unsigned TMR3ON             : 1;
    unsigned RD16               : 1;
    unsigned NOT_T3SYNC         : 1;
    unsigned SOSCEN             : 1;
    unsigned T3CKPS0            : 1;
    unsigned T3CKPS1            : 1;
    unsigned TMR3CS0            : 1;
    unsigned TMR3CS1            : 1;
    };

  struct
    {
    unsigned                    : 4;
    unsigned T3CKPS             : 2;
    unsigned                    : 2;
    };

  struct
    {
    unsigned                    : 6;
    unsigned TMR3CS             : 2;
    };
  } __T3CONbits_t;

extern __at(0x0FB1) volatile __T3CONbits_t T3CONbits;

#define _T3CON_TMR3ON           0x01
#define _T3CON_RD16             0x02
#define _T3CON_NOT_T3SYNC       0x04
#define _T3CON_SOSCEN           0x08
#define _T3CON_T3CKPS0          0x10
#define _T3CON_T3CKPS1          0x20
#define _T3CON_TMR3CS0          0x40
#define _T3CON_TMR3CS1          0x80

//==============================================================================

extern __at(0x0FB2) __sfr TMR3;
extern __at(0x0FB2) __sfr TMR3L;
extern __at(0x0FB3) __sfr TMR3H;

//==============================================================================
//        CMSTAT Bits

extern __at(0x0FB4) __sfr CMSTAT;

typedef struct
  {
  unsigned                      : 1;
  unsigned                      : 1;
  unsigned                      : 1;
  unsigned                      : 1;
  unsigned                      : 1;
  unsigned CMP1OUT              : 1;
  unsigned CMP2OUT              : 1;
  unsigned CMP3OUT              : 1;
  } __CMSTATbits_t;

extern __at(0x0FB4) volatile __CMSTATbits_t CMSTATbits;

#define _CMP1OUT                0x20
#define _CMP2OUT                0x40
#define _CMP3OUT                0x80

//==============================================================================


//==============================================================================
//        CMSTATUS Bits

extern __at(0x0FB4) __sfr CMSTATUS;

typedef struct
  {
  unsigned                      : 1;
  unsigned                      : 1;
  unsigned                      : 1;
  unsigned                      : 1;
  unsigned                      : 1;
  unsigned CMP1OUT              : 1;
  unsigned CMP2OUT              : 1;
  unsigned CMP3OUT              : 1;
  } __CMSTATUSbits_t;

extern __at(0x0FB4) volatile __CMSTATUSbits_t CMSTATUSbits;

#define _CMSTATUS_CMP1OUT       0x20
#define _CMSTATUS_CMP2OUT       0x40
#define _CMSTATUS_CMP3OUT       0x80

//==============================================================================


//==============================================================================
//        CVRCON Bits

extern __at(0x0FB5) __sfr CVRCON;

typedef union
  {
  struct
    {
    unsigned CVR0               : 1;
    unsigned CVR1               : 1;
    unsigned CVR2               : 1;
    unsigned CVR3               : 1;
    unsigned CVR4               : 1;
    unsigned CVRSS              : 1;
    unsigned CVROE              : 1;
    unsigned CVREN              : 1;
    };

  struct
    {
    unsigned CVR                : 5;
    unsigned                    : 3;
    };
  } __CVRCONbits_t;

extern __at(0x0FB5) volatile __CVRCONbits_t CVRCONbits;

#define _CVR0                   0x01
#define _CVR1                   0x02
#define _CVR2                   0x04
#define _CVR3                   0x08
#define _CVR4                   0x10
#define _CVRSS                  0x20
#define _CVROE                  0x40
#define _CVREN                  0x80

//==============================================================================


//==============================================================================
//        PIE4 Bits

extern __at(0x0FB6) __sfr PIE4;

typedef struct
  {
  unsigned CCP3IE               : 1;
  unsigned CCP4IE               : 1;
  unsigned CCP5IE               : 1;
  unsigned CCP6IE               : 1;
  unsigned CCP7IE               : 1;
  unsigned CCP8IE               : 1;
  unsigned CCP9IE               : 1;
  unsigned CCP10IE              : 1;
  } __PIE4bits_t;

extern __at(0x0FB6) volatile __PIE4bits_t PIE4bits;

#define _CCP3IE                 0x01
#define _CCP4IE                 0x02
#define _CCP5IE                 0x04
#define _CCP6IE                 0x08
#define _CCP7IE                 0x10
#define _CCP8IE                 0x20
#define _CCP9IE                 0x40
#define _CCP10IE                0x80

//==============================================================================


//==============================================================================
//        PIR4 Bits

extern __at(0x0FB7) __sfr PIR4;

typedef struct
  {
  unsigned CCP3IF               : 1;
  unsigned CCP4IF               : 1;
  unsigned CCP5IF               : 1;
  unsigned CCP6IF               : 1;
  unsigned CCP7IF               : 1;
  unsigned CCP8IF               : 1;
  unsigned CCP9IF               : 1;
  unsigned CCP10IF              : 1;
  } __PIR4bits_t;

extern __at(0x0FB7) volatile __PIR4bits_t PIR4bits;

#define _CCP3IF                 0x01
#define _CCP4IF                 0x02
#define _CCP5IF                 0x04
#define _CCP6IF                 0x08
#define _CCP7IF                 0x10
#define _CCP8IF                 0x20
#define _CCP9IF                 0x40
#define _CCP10IF                0x80

//==============================================================================


//==============================================================================
//        IPR4 Bits

extern __at(0x0FB8) __sfr IPR4;

typedef struct
  {
  unsigned CCP3IP               : 1;
  unsigned CCP4IP               : 1;
  unsigned CCP5IP               : 1;
  unsigned CCP6IP               : 1;
  unsigned CCP7IP               : 1;
  unsigned CCP8IP               : 1;
  unsigned CCP9IP               : 1;
  unsigned CCP10IP              : 1;
  } __IPR4bits_t;

extern __at(0x0FB8) volatile __IPR4bits_t IPR4bits;

#define _CCP3IP                 0x01
#define _CCP4IP                 0x02
#define _CCP5IP                 0x04
#define _CCP6IP                 0x08
#define _CCP7IP                 0x10
#define _CCP8IP                 0x20
#define _CCP9IP                 0x40
#define _CCP10IP                0x80

//==============================================================================


//==============================================================================
//        PIE5 Bits

extern __at(0x0FB9) __sfr PIE5;

typedef struct
  {
  unsigned TMR4IE               : 1;
  unsigned TMR5IE               : 1;
  unsigned TMR6IE               : 1;
  unsigned TMR7IE               : 1;
  unsigned TMR8IE               : 1;
  unsigned TMR10IE              : 1;
  unsigned TMR12IE              : 1;
  unsigned TMR7GIE              : 1;
  } __PIE5bits_t;

extern __at(0x0FB9) volatile __PIE5bits_t PIE5bits;

#define _TMR4IE                 0x01
#define _TMR5IE                 0x02
#define _TMR6IE                 0x04
#define _TMR7IE                 0x08
#define _TMR8IE                 0x10
#define _TMR10IE                0x20
#define _TMR12IE                0x40
#define _TMR7GIE                0x80

//==============================================================================


//==============================================================================
//        PIR5 Bits

extern __at(0x0FBA) __sfr PIR5;

typedef struct
  {
  unsigned TMR4IF               : 1;
  unsigned TMR5IF               : 1;
  unsigned TMR6IF               : 1;
  unsigned TMR7IF               : 1;
  unsigned TMR8IF               : 1;
  unsigned TMR10IF              : 1;
  unsigned TMR12IF              : 1;
  unsigned TMR7GIF              : 1;
  } __PIR5bits_t;

extern __at(0x0FBA) volatile __PIR5bits_t PIR5bits;

#define _TMR4IF                 0x01
#define _TMR5IF                 0x02
#define _TMR6IF                 0x04
#define _TMR7IF                 0x08
#define _TMR8IF                 0x10
#define _TMR10IF                0x20
#define _TMR12IF                0x40
#define _TMR7GIF                0x80

//==============================================================================


//==============================================================================
//        CCP1CON Bits

extern __at(0x0FBB) __sfr CCP1CON;

typedef union
  {
  struct
    {
    unsigned CCP1M0             : 1;
    unsigned CCP1M1             : 1;
    unsigned CCP1M2             : 1;
    unsigned CCP1M3             : 1;
    unsigned DC1B0              : 1;
    unsigned DC1B1              : 1;
    unsigned P1M0               : 1;
    unsigned P1M1               : 1;
    };

  struct
    {
    unsigned                    : 1;
    unsigned                    : 1;
    unsigned                    : 1;
    unsigned                    : 1;
    unsigned CCP1Y              : 1;
    unsigned CCP1X              : 1;
    unsigned                    : 1;
    unsigned                    : 1;
    };

  struct
    {
    unsigned CCP1M              : 4;
    unsigned                    : 4;
    };

  struct
    {
    unsigned                    : 4;
    unsigned DC1B               : 2;
    unsigned                    : 2;
    };

  struct
    {
    unsigned                    : 6;
    unsigned P1M                : 2;
    };
  } __CCP1CONbits_t;

extern __at(0x0FBB) volatile __CCP1CONbits_t CCP1CONbits;

#define _CCP1M0                 0x01
#define _CCP1M1                 0x02
#define _CCP1M2                 0x04
#define _CCP1M3                 0x08
#define _DC1B0                  0x10
#define _CCP1Y                  0x10
#define _DC1B1                  0x20
#define _CCP1X                  0x20
#define _P1M0                   0x40
#define _P1M1                   0x80

//==============================================================================


//==============================================================================
//        ECCP1CON Bits

extern __at(0x0FBB) __sfr ECCP1CON;

typedef union
  {
  struct
    {
    unsigned CCP1M0             : 1;
    unsigned CCP1M1             : 1;
    unsigned CCP1M2             : 1;
    unsigned CCP1M3             : 1;
    unsigned DC1B0              : 1;
    unsigned DC1B1              : 1;
    unsigned P1M0               : 1;
    unsigned P1M1               : 1;
    };

  struct
    {
    unsigned                    : 1;
    unsigned                    : 1;
    unsigned                    : 1;
    unsigned                    : 1;
    unsigned CCP1Y              : 1;
    unsigned CCP1X              : 1;
    unsigned                    : 1;
    unsigned                    : 1;
    };

  struct
    {
    unsigned CCP1M              : 4;
    unsigned                    : 4;
    };

  struct
    {
    unsigned                    : 4;
    unsigned DC1B               : 2;
    unsigned                    : 2;
    };

  struct
    {
    unsigned                    : 6;
    unsigned P1M                : 2;
    };
  } __ECCP1CONbits_t;

extern __at(0x0FBB) volatile __ECCP1CONbits_t ECCP1CONbits;

#define _ECCP1CON_CCP1M0        0x01
#define _ECCP1CON_CCP1M1        0x02
#define _ECCP1CON_CCP1M2        0x04
#define _ECCP1CON_CCP1M3        0x08
#define _ECCP1CON_DC1B0         0x10
#define _ECCP1CON_CCP1Y         0x10
#define _ECCP1CON_DC1B1         0x20
#define _ECCP1CON_CCP1X         0x20
#define _ECCP1CON_P1M0          0x40
#define _ECCP1CON_P1M1          0x80

//==============================================================================

extern __at(0x0FBC) __sfr CCPR1;
extern __at(0x0FBC) __sfr CCPR1L;
extern __at(0x0FBD) __sfr CCPR1H;

//==============================================================================
//        ECCP1DEL Bits

extern __at(0x0FBE) __sfr ECCP1DEL;

typedef union
  {
  struct
    {
    unsigned P1DC0              : 1;
    unsigned P1DC1              : 1;
    unsigned P1DC2              : 1;
    unsigned P1DC3              : 1;
    unsigned P1DC4              : 1;
    unsigned P1DC5              : 1;
    unsigned P1DC6              : 1;
    unsigned P1RSEN             : 1;
    };

  struct
    {
    unsigned P1DC               : 7;
    unsigned                    : 1;
    };
  } __ECCP1DELbits_t;

extern __at(0x0FBE) volatile __ECCP1DELbits_t ECCP1DELbits;

#define _P1DC0                  0x01
#define _P1DC1                  0x02
#define _P1DC2                  0x04
#define _P1DC3                  0x08
#define _P1DC4                  0x10
#define _P1DC5                  0x20
#define _P1DC6                  0x40
#define _P1RSEN                 0x80

//==============================================================================


//==============================================================================
//        PWM1CON Bits

extern __at(0x0FBE) __sfr PWM1CON;

typedef union
  {
  struct
    {
    unsigned P1DC0              : 1;
    unsigned P1DC1              : 1;
    unsigned P1DC2              : 1;
    unsigned P1DC3              : 1;
    unsigned P1DC4              : 1;
    unsigned P1DC5              : 1;
    unsigned P1DC6              : 1;
    unsigned P1RSEN             : 1;
    };

  struct
    {
    unsigned P1DC               : 7;
    unsigned                    : 1;
    };
  } __PWM1CONbits_t;

extern __at(0x0FBE) volatile __PWM1CONbits_t PWM1CONbits;

#define _PWM1CON_P1DC0          0x01
#define _PWM1CON_P1DC1          0x02
#define _PWM1CON_P1DC2          0x04
#define _PWM1CON_P1DC3          0x08
#define _PWM1CON_P1DC4          0x10
#define _PWM1CON_P1DC5          0x20
#define _PWM1CON_P1DC6          0x40
#define _PWM1CON_P1RSEN         0x80

//==============================================================================


//==============================================================================
//        ECCP1AS Bits

extern __at(0x0FBF) __sfr ECCP1AS;

typedef union
  {
  struct
    {
    unsigned PSS1BD0            : 1;
    unsigned PSS1BD1            : 1;
    unsigned PSS1AC0            : 1;
    unsigned PSS1AC1            : 1;
    unsigned ECCP1AS0           : 1;
    unsigned ECCP1AS1           : 1;
    unsigned ECCP1AS2           : 1;
    unsigned ECCP1ASE           : 1;
    };

  struct
    {
    unsigned PSS1BD             : 2;
    unsigned                    : 6;
    };

  struct
    {
    unsigned                    : 2;
    unsigned PSS1AC             : 2;
    unsigned                    : 4;
    };

  struct
    {
    unsigned                    : 4;
    unsigned ECCP1AS            : 3;
    unsigned                    : 1;
    };
  } __ECCP1ASbits_t;

extern __at(0x0FBF) volatile __ECCP1ASbits_t ECCP1ASbits;

#define _PSS1BD0                0x01
#define _PSS1BD1                0x02
#define _PSS1AC0                0x04
#define _PSS1AC1                0x08
#define _ECCP1AS0               0x10
#define _ECCP1AS1               0x20
#define _ECCP1AS2               0x40
#define _ECCP1ASE               0x80

//==============================================================================


//==============================================================================
//        ADCON2 Bits

extern __at(0x0FC0) __sfr ADCON2;

typedef union
  {
  struct
    {
    unsigned ADCS0              : 1;
    unsigned ADCS1              : 1;
    unsigned ADCS2              : 1;
    unsigned ACQT0              : 1;
    unsigned ACQT1              : 1;
    unsigned ACQT2              : 1;
    unsigned                    : 1;
    unsigned ADFM               : 1;
    };

  struct
    {
    unsigned ADCS               : 3;
    unsigned                    : 5;
    };

  struct
    {
    unsigned                    : 3;
    unsigned ACQT               : 3;
    unsigned                    : 2;
    };
  } __ADCON2bits_t;

extern __at(0x0FC0) volatile __ADCON2bits_t ADCON2bits;

#define _ADCS0                  0x01
#define _ADCS1                  0x02
#define _ADCS2                  0x04
#define _ACQT0                  0x08
#define _ACQT1                  0x10
#define _ACQT2                  0x20
#define _ADFM                   0x80

//==============================================================================


//==============================================================================
//        ADCON1 Bits

extern __at(0x0FC1) __sfr ADCON1;

typedef union
  {
  struct
    {
    unsigned CHSN0              : 1;
    unsigned CHSN1              : 1;
    unsigned CHSN2              : 1;
    unsigned VNCFG              : 1;
    unsigned VCFG0              : 1;
    unsigned VCFG1              : 1;
    unsigned TRIGSEL0           : 1;
    unsigned TRIGSEL1           : 1;
    };

  struct
    {
    unsigned CHSN               : 3;
    unsigned                    : 5;
    };

  struct
    {
    unsigned                    : 4;
    unsigned VCFG               : 2;
    unsigned                    : 2;
    };

  struct
    {
    unsigned                    : 6;
    unsigned TRIGSEL            : 2;
    };
  } __ADCON1bits_t;

extern __at(0x0FC1) volatile __ADCON1bits_t ADCON1bits;

#define _CHSN0                  0x01
#define _CHSN1                  0x02
#define _CHSN2                  0x04
#define _VNCFG                  0x08
#define _VCFG0                  0x10
#define _VCFG1                  0x20
#define _TRIGSEL0               0x40
#define _TRIGSEL1               0x80

//==============================================================================


//==============================================================================
//        ADCON0 Bits

extern __at(0x0FC2) __sfr ADCON0;

typedef union
  {
  struct
    {
    unsigned ADON               : 1;
    unsigned GO_NOT_DONE        : 1;
    unsigned CHS0               : 1;
    unsigned CHS1               : 1;
    unsigned CHS2               : 1;
    unsigned CHS3               : 1;
    unsigned CHS4               : 1;
    unsigned                    : 1;
    };

  struct
    {
    unsigned                    : 1;
    unsigned DONE               : 1;
    unsigned                    : 1;
    unsigned                    : 1;
    unsigned                    : 1;
    unsigned                    : 1;
    unsigned                    : 1;
    unsigned                    : 1;
    };

  struct
    {
    unsigned                    : 1;
    unsigned GO                 : 1;
    unsigned                    : 1;
    unsigned                    : 1;
    unsigned                    : 1;
    unsigned                    : 1;
    unsigned                    : 1;
    unsigned                    : 1;
    };

  struct
    {
    unsigned                    : 1;
    unsigned NOT_DONE           : 1;
    unsigned                    : 1;
    unsigned                    : 1;
    unsigned                    : 1;
    unsigned                    : 1;
    unsigned                    : 1;
    unsigned                    : 1;
    };

  struct
    {
    unsigned                    : 2;
    unsigned CHS                : 5;
    unsigned                    : 1;
    };
  } __ADCON0bits_t;

extern __at(0x0FC2) volatile __ADCON0bits_t ADCON0bits;

#define _ADON                   0x01
#define _GO_NOT_DONE            0x02
#define _DONE                   0x02
#define _GO                     0x02
#define _NOT_DONE               0x02
#define _CHS0                   0x04
#define _CHS1                   0x08
#define _CHS2                   0x10
#define _CHS3                   0x20
#define _CHS4                   0x40

//==============================================================================

extern __at(0x0FC3) __sfr ADRES;
extern __at(0x0FC3) __sfr ADRESL;
extern __at(0x0FC4) __sfr ADRESH;

//==============================================================================
//        SSP1CON2 Bits

extern __at(0x0FC5) __sfr SSP1CON2;

typedef union
  {
  struct
    {
    unsigned SEN                : 1;
    unsigned RSEN               : 1;
    unsigned PEN                : 1;
    unsigned RCEN               : 1;
    unsigned ACKEN              : 1;
    unsigned ACKDT              : 1;
    unsigned ACKSTAT            : 1;
    unsigned GCEN               : 1;
    };

  struct
    {
    unsigned                    : 1;
    unsigned ADMSK1             : 1;
    unsigned ADMSK2             : 1;
    unsigned ADMSK3             : 1;
    unsigned ADMSK4             : 1;
    unsigned ADMSK5             : 1;
    unsigned                    : 1;
    unsigned                    : 1;
    };
  } __SSP1CON2bits_t;

extern __at(0x0FC5) volatile __SSP1CON2bits_t SSP1CON2bits;

#define _SEN                    0x01
#define _RSEN                   0x02
#define _ADMSK1                 0x02
#define _PEN                    0x04
#define _ADMSK2                 0x04
#define _RCEN                   0x08
#define _ADMSK3                 0x08
#define _ACKEN                  0x10
#define _ADMSK4                 0x10
#define _ACKDT                  0x20
#define _ADMSK5                 0x20
#define _ACKSTAT                0x40
#define _GCEN                   0x80

//==============================================================================


//==============================================================================
//        SSPCON2 Bits

extern __at(0x0FC5) __sfr SSPCON2;

typedef union
  {
  struct
    {
    unsigned SEN                : 1;
    unsigned RSEN               : 1;
    unsigned PEN                : 1;
    unsigned RCEN               : 1;
    unsigned ACKEN              : 1;
    unsigned ACKDT              : 1;
    unsigned ACKSTAT            : 1;
    unsigned GCEN               : 1;
    };

  struct
    {
    unsigned                    : 1;
    unsigned ADMSK1             : 1;
    unsigned ADMSK2             : 1;
    unsigned ADMSK3             : 1;
    unsigned ADMSK4             : 1;
    unsigned ADMSK5             : 1;
    unsigned                    : 1;
    unsigned                    : 1;
    };
  } __SSPCON2bits_t;

extern __at(0x0FC5) volatile __SSPCON2bits_t SSPCON2bits;

#define _SSPCON2_SEN            0x01
#define _SSPCON2_RSEN           0x02
#define _SSPCON2_ADMSK1         0x02
#define _SSPCON2_PEN            0x04
#define _SSPCON2_ADMSK2         0x04
#define _SSPCON2_RCEN           0x08
#define _SSPCON2_ADMSK3         0x08
#define _SSPCON2_ACKEN          0x10
#define _SSPCON2_ADMSK4         0x10
#define _SSPCON2_ACKDT          0x20
#define _SSPCON2_ADMSK5         0x20
#define _SSPCON2_ACKSTAT        0x40
#define _SSPCON2_GCEN           0x80

//==============================================================================


//==============================================================================
//        SSP1CON1 Bits

extern __at(0x0FC6) __sfr SSP1CON1;

typedef union
  {
  struct
    {
    unsigned SSPM0              : 1;
    unsigned SSPM1              : 1;
    unsigned SSPM2              : 1;
    unsigned SSPM3              : 1;
    unsigned CKP                : 1;
    unsigned SSPEN              : 1;
    unsigned SSPOV              : 1;
    unsigned WCOL               : 1;
    };

  struct
    {
    unsigned SSPM               : 4;
    unsigned                    : 4;
    };
  } __SSP1CON1bits_t;

extern __at(0x0FC6) volatile __SSP1CON1bits_t SSP1CON1bits;

#define _SSPM0                  0x01
#define _SSPM1                  0x02
#define _SSPM2                  0x04
#define _SSPM3                  0x08
#define _CKP                    0x10
#define _SSPEN                  0x20
#define _SSPOV                  0x40
#define _WCOL                   0x80

//==============================================================================


//==============================================================================
//        SSPCON1 Bits

extern __at(0x0FC6) __sfr SSPCON1;

typedef union
  {
  struct
    {
    unsigned SSPM0              : 1;
    unsigned SSPM1              : 1;
    unsigned SSPM2              : 1;
    unsigned SSPM3              : 1;
    unsigned CKP                : 1;
    unsigned SSPEN              : 1;
    unsigned SSPOV              : 1;
    unsigned WCOL               : 1;
    };

  struct
    {
    unsigned SSPM               : 4;
    unsigned                    : 4;
    };
  } __SSPCON1bits_t;

extern __at(0x0FC6) volatile __SSPCON1bits_t SSPCON1bits;

#define _SSPCON1_SSPM0          0x01
#define _SSPCON1_SSPM1          0x02
#define _SSPCON1_SSPM2          0x04
#define _SSPCON1_SSPM3          0x08
#define _SSPCON1_CKP            0x10
#define _SSPCON1_SSPEN          0x20
#define _SSPCON1_SSPOV          0x40
#define _SSPCON1_WCOL           0x80

//==============================================================================


//==============================================================================
//        SSP1STAT Bits

extern __at(0x0FC7) __sfr SSP1STAT;

typedef union
  {
  struct
    {
    unsigned BF                 : 1;
    unsigned UA                 : 1;
    unsigned R_NOT_W            : 1;
    unsigned S                  : 1;
    unsigned P                  : 1;
    unsigned D_NOT_A            : 1;
    unsigned CKE                : 1;
    unsigned SMP                : 1;
    };

  struct
    {
    unsigned                    : 1;
    unsigned                    : 1;
    unsigned R                  : 1;
    unsigned I2C_START          : 1;
    unsigned I2C_STOP           : 1;
    unsigned D                  : 1;
    unsigned                    : 1;
    unsigned                    : 1;
    };

  struct
    {
    unsigned                    : 1;
    unsigned                    : 1;
    unsigned R_W                : 1;
    unsigned                    : 1;
    unsigned                    : 1;
    unsigned D_A                : 1;
    unsigned                    : 1;
    unsigned                    : 1;
    };

  struct
    {
    unsigned                    : 1;
    unsigned                    : 1;
    unsigned NOT_W              : 1;
    unsigned                    : 1;
    unsigned                    : 1;
    unsigned NOT_A              : 1;
    unsigned                    : 1;
    unsigned                    : 1;
    };

  struct
    {
    unsigned                    : 1;
    unsigned                    : 1;
    unsigned NOT_WRITE          : 1;
    unsigned                    : 1;
    unsigned                    : 1;
    unsigned NOT_ADDRESS        : 1;
    unsigned                    : 1;
    unsigned                    : 1;
    };

  struct
    {
    unsigned                    : 1;
    unsigned                    : 1;
    unsigned READ_WRITE         : 1;
    unsigned                    : 1;
    unsigned                    : 1;
    unsigned DATA_ADDRESS       : 1;
    unsigned                    : 1;
    unsigned                    : 1;
    };

  struct
    {
    unsigned                    : 1;
    unsigned                    : 1;
    unsigned I2C_READ           : 1;
    unsigned                    : 1;
    unsigned                    : 1;
    unsigned I2C_DAT            : 1;
    unsigned                    : 1;
    unsigned                    : 1;
    };
  } __SSP1STATbits_t;

extern __at(0x0FC7) volatile __SSP1STATbits_t SSP1STATbits;

#define _BF                     0x01
#define _UA                     0x02
#define _R_NOT_W                0x04
#define _R                      0x04
#define _R_W                    0x04
#define _NOT_W                  0x04
#define _NOT_WRITE              0x04
#define _READ_WRITE             0x04
#define _I2C_READ               0x04
#define _S                      0x08
#define _I2C_START              0x08
#define _P                      0x10
#define _I2C_STOP               0x10
#define _D_NOT_A                0x20
#define _D                      0x20
#define _D_A                    0x20
#define _NOT_A                  0x20
#define _NOT_ADDRESS            0x20
#define _DATA_ADDRESS           0x20
#define _I2C_DAT                0x20
#define _CKE                    0x40
#define _SMP                    0x80

//==============================================================================


//==============================================================================
//        SSPSTAT Bits

extern __at(0x0FC7) __sfr SSPSTAT;

typedef union
  {
  struct
    {
    unsigned BF                 : 1;
    unsigned UA                 : 1;
    unsigned R_NOT_W            : 1;
    unsigned S                  : 1;
    unsigned P                  : 1;
    unsigned D_NOT_A            : 1;
    unsigned CKE                : 1;
    unsigned SMP                : 1;
    };

  struct
    {
    unsigned                    : 1;
    unsigned                    : 1;
    unsigned R                  : 1;
    unsigned I2C_START          : 1;
    unsigned I2C_STOP           : 1;
    unsigned D                  : 1;
    unsigned                    : 1;
    unsigned                    : 1;
    };

  struct
    {
    unsigned                    : 1;
    unsigned                    : 1;
    unsigned R_W                : 1;
    unsigned                    : 1;
    unsigned                    : 1;
    unsigned D_A                : 1;
    unsigned                    : 1;
    unsigned                    : 1;
    };

  struct
    {
    unsigned                    : 1;
    unsigned                    : 1;
    unsigned NOT_W              : 1;
    unsigned                    : 1;
    unsigned                    : 1;
    unsigned NOT_A              : 1;
    unsigned                    : 1;
    unsigned                    : 1;
    };

  struct
    {
    unsigned                    : 1;
    unsigned                    : 1;
    unsigned NOT_WRITE          : 1;
    unsigned                    : 1;
    unsigned                    : 1;
    unsigned NOT_ADDRESS        : 1;
    unsigned                    : 1;
    unsigned                    : 1;
    };

  struct
    {
    unsigned                    : 1;
    unsigned                    : 1;
    unsigned READ_WRITE         : 1;
    unsigned                    : 1;
    unsigned                    : 1;
    unsigned DATA_ADDRESS       : 1;
    unsigned                    : 1;
    unsigned                    : 1;
    };

  struct
    {
    unsigned                    : 1;
    unsigned                    : 1;
    unsigned I2C_READ           : 1;
    unsigned                    : 1;
    unsigned                    : 1;
    unsigned I2C_DAT            : 1;
    unsigned                    : 1;
    unsigned                    : 1;
    };
  } __SSPSTATbits_t;

extern __at(0x0FC7) volatile __SSPSTATbits_t SSPSTATbits;

#define _SSPSTAT_BF             0x01
#define _SSPSTAT_UA             0x02
#define _SSPSTAT_R_NOT_W        0x04
#define _SSPSTAT_R              0x04
#define _SSPSTAT_R_W            0x04
#define _SSPSTAT_NOT_W          0x04
#define _SSPSTAT_NOT_WRITE      0x04
#define _SSPSTAT_READ_WRITE     0x04
#define _SSPSTAT_I2C_READ       0x04
#define _SSPSTAT_S              0x08
#define _SSPSTAT_I2C_START      0x08
#define _SSPSTAT_P              0x10
#define _SSPSTAT_I2C_STOP       0x10
#define _SSPSTAT_D_NOT_A        0x20
#define _SSPSTAT_D              0x20
#define _SSPSTAT_D_A            0x20
#define _SSPSTAT_NOT_A          0x20
#define _SSPSTAT_NOT_ADDRESS    0x20
#define _SSPSTAT_DATA_ADDRESS   0x20
#define _SSPSTAT_I2C_DAT        0x20
#define _SSPSTAT_CKE            0x40
#define _SSPSTAT_SMP            0x80

//==============================================================================

extern __at(0x0FC8) __sfr SSP1ADD;

//==============================================================================
//        SSP1MSK Bits

extern __at(0x0FC8) __sfr SSP1MSK;

typedef struct
  {
  unsigned MSK0                 : 1;
  unsigned MSK1                 : 1;
  unsigned MSK2                 : 1;
  unsigned MSK3                 : 1;
  unsigned MSK4                 : 1;
  unsigned MSK5                 : 1;
  unsigned MSK6                 : 1;
  unsigned MSK7                 : 1;
  } __SSP1MSKbits_t;

extern __at(0x0FC8) volatile __SSP1MSKbits_t SSP1MSKbits;

#define _MSK0                   0x01
#define _MSK1                   0x02
#define _MSK2                   0x04
#define _MSK3                   0x08
#define _MSK4                   0x10
#define _MSK5                   0x20
#define _MSK6                   0x40
#define _MSK7                   0x80

//==============================================================================

extern __at(0x0FC8) __sfr SSPADD;
extern __at(0x0FC9) __sfr SSP1BUF;
extern __at(0x0FC9) __sfr SSPBUF;

//==============================================================================
//        T2CON Bits

extern __at(0x0FCA) __sfr T2CON;

typedef union
  {
  struct
    {
    unsigned T2CKPS0            : 1;
    unsigned T2CKPS1            : 1;
    unsigned TMR2ON             : 1;
    unsigned T2OUTPS0           : 1;
    unsigned T2OUTPS1           : 1;
    unsigned T2OUTPS2           : 1;
    unsigned T2OUTPS3           : 1;
    unsigned                    : 1;
    };

  struct
    {
    unsigned T2CKPS             : 2;
    unsigned                    : 6;
    };

  struct
    {
    unsigned                    : 3;
    unsigned T2OUTPS            : 4;
    unsigned                    : 1;
    };
  } __T2CONbits_t;

extern __at(0x0FCA) volatile __T2CONbits_t T2CONbits;

#define _T2CKPS0                0x01
#define _T2CKPS1                0x02
#define _TMR2ON                 0x04
#define _T2OUTPS0               0x08
#define _T2OUTPS1               0x10
#define _T2OUTPS2               0x20
#define _T2OUTPS3               0x40

//==============================================================================

extern __at(0x0FCB) __sfr PR2;
extern __at(0x0FCC) __sfr TMR2;

//==============================================================================
//        T1CON Bits

extern __at(0x0FCD) __sfr T1CON;

typedef union
  {
  struct
    {
    unsigned TMR1ON             : 1;
    unsigned RD16               : 1;
    unsigned NOT_T1SYNC         : 1;
    unsigned SOSCEN             : 1;
    unsigned T1CKPS0            : 1;
    unsigned T1CKPS1            : 1;
    unsigned TMR1CS0            : 1;
    unsigned TMR1CS1            : 1;
    };

  struct
    {
    unsigned                    : 4;
    unsigned T1CKPS             : 2;
    unsigned                    : 2;
    };

  struct
    {
    unsigned                    : 6;
    unsigned TMR1CS             : 2;
    };
  } __T1CONbits_t;

extern __at(0x0FCD) volatile __T1CONbits_t T1CONbits;

#define _TMR1ON                 0x01
#define _RD16                   0x02
#define _NOT_T1SYNC             0x04
#define _SOSCEN                 0x08
#define _T1CKPS0                0x10
#define _T1CKPS1                0x20
#define _TMR1CS0                0x40
#define _TMR1CS1                0x80

//==============================================================================

extern __at(0x0FCE) __sfr TMR1;
extern __at(0x0FCE) __sfr TMR1L;
extern __at(0x0FCF) __sfr TMR1H;

//==============================================================================
//        RCON Bits

extern __at(0x0FD0) __sfr RCON;

typedef union
  {
  struct
    {
    unsigned NOT_BOR            : 1;
    unsigned NOT_POR            : 1;
    unsigned NOT_PD             : 1;
    unsigned NOT_TO             : 1;
    unsigned NOT_RI             : 1;
    unsigned NOT_CM             : 1;
    unsigned SBOREN             : 1;
    unsigned IPEN               : 1;
    };

  struct
    {
    unsigned BOR                : 1;
    unsigned POR                : 1;
    unsigned PD                 : 1;
    unsigned TO                 : 1;
    unsigned RI                 : 1;
    unsigned CM                 : 1;
    unsigned                    : 1;
    unsigned                    : 1;
    };
  } __RCONbits_t;

extern __at(0x0FD0) volatile __RCONbits_t RCONbits;

#define _NOT_BOR                0x01
#define _BOR                    0x01
#define _NOT_POR                0x02
#define _POR                    0x02
#define _NOT_PD                 0x04
#define _PD                     0x04
#define _NOT_TO                 0x08
#define _TO                     0x08
#define _NOT_RI                 0x10
#define _RI                     0x10
#define _NOT_CM                 0x20
#define _CM                     0x20
#define _SBOREN                 0x40
#define _IPEN                   0x80

//==============================================================================


//==============================================================================
//        WDTCON Bits

extern __at(0x0FD1) __sfr WDTCON;

typedef union
  {
  struct
    {
    unsigned SWDTEN             : 1;
    unsigned ULPSINK            : 1;
    unsigned ULPEN              : 1;
    unsigned                    : 1;
    unsigned SRETEN             : 1;
    unsigned ULPLVL             : 1;
    unsigned                    : 1;
    unsigned REGSLP             : 1;
    };

  struct
    {
    unsigned SWDTE              : 1;
    unsigned                    : 1;
    unsigned                    : 1;
    unsigned                    : 1;
    unsigned                    : 1;
    unsigned                    : 1;
    unsigned                    : 1;
    unsigned                    : 1;
    };
  } __WDTCONbits_t;

extern __at(0x0FD1) volatile __WDTCONbits_t WDTCONbits;

#define _SWDTEN                 0x01
#define _SWDTE                  0x01
#define _ULPSINK                0x02
#define _ULPEN                  0x04
#define _SRETEN                 0x10
#define _ULPLVL                 0x20
#define _REGSLP                 0x80

//==============================================================================


//==============================================================================
//        IPR5 Bits

extern __at(0x0FD2) __sfr IPR5;

typedef struct
  {
  unsigned TMR4IP               : 1;
  unsigned TMR5IP               : 1;
  unsigned TMR6IP               : 1;
  unsigned TMR7IP               : 1;
  unsigned TMR8IP               : 1;
  unsigned TMR10IP              : 1;
  unsigned TMR12IP              : 1;
  unsigned TMR7GIP              : 1;
  } __IPR5bits_t;

extern __at(0x0FD2) volatile __IPR5bits_t IPR5bits;

#define _TMR4IP                 0x01
#define _TMR5IP                 0x02
#define _TMR6IP                 0x04
#define _TMR7IP                 0x08
#define _TMR8IP                 0x10
#define _TMR10IP                0x20
#define _TMR12IP                0x40
#define _TMR7GIP                0x80

//==============================================================================


//==============================================================================
//        OSCCON Bits

extern __at(0x0FD3) __sfr OSCCON;

typedef union
  {
  struct
    {
    unsigned SCS0               : 1;
    unsigned SCS1               : 1;
    unsigned HFIOFS             : 1;
    unsigned OSTS               : 1;
    unsigned IRCF0              : 1;
    unsigned IRCF1              : 1;
    unsigned IRCF2              : 1;
    unsigned IDLEN              : 1;
    };

  struct
    {
    unsigned SCS                : 2;
    unsigned                    : 6;
    };

  struct
    {
    unsigned                    : 4;
    unsigned IRCF               : 3;
    unsigned                    : 1;
    };
  } __OSCCONbits_t;

extern __at(0x0FD3) volatile __OSCCONbits_t OSCCONbits;

#define _SCS0                   0x01
#define _SCS1                   0x02
#define _HFIOFS                 0x04
#define _OSTS                   0x08
#define _IRCF0                  0x10
#define _IRCF1                  0x20
#define _IRCF2                  0x40
#define _IDLEN                  0x80

//==============================================================================

extern __at(0x0FD4) __sfr SPBRGH1;

//==============================================================================
//        T0CON Bits

extern __at(0x0FD5) __sfr T0CON;

typedef union
  {
  struct
    {
    unsigned T0PS0              : 1;
    unsigned T0PS1              : 1;
    unsigned T0PS2              : 1;
    unsigned PSA                : 1;
    unsigned T0SE               : 1;
    unsigned T0CS               : 1;
    unsigned T08BIT             : 1;
    unsigned TMR0ON             : 1;
    };

  struct
    {
    unsigned T0PS               : 3;
    unsigned                    : 5;
    };
  } __T0CONbits_t;

extern __at(0x0FD5) volatile __T0CONbits_t T0CONbits;

#define _T0PS0                  0x01
#define _T0PS1                  0x02
#define _T0PS2                  0x04
#define _PSA                    0x08
#define _T0SE                   0x10
#define _T0CS                   0x20
#define _T08BIT                 0x40
#define _TMR0ON                 0x80

//==============================================================================

extern __at(0x0FD6) __sfr TMR0;
extern __at(0x0FD6) __sfr TMR0L;
extern __at(0x0FD7) __sfr TMR0H;

//==============================================================================
//        STATUS Bits

extern __at(0x0FD8) __sfr STATUS;

typedef struct
  {
  unsigned C                    : 1;
  unsigned DC                   : 1;
  unsigned Z                    : 1;
  unsigned OV                   : 1;
  unsigned N                    : 1;
  unsigned                      : 1;
  unsigned                      : 1;
  unsigned                      : 1;
  } __STATUSbits_t;

extern __at(0x0FD8) volatile __STATUSbits_t STATUSbits;

#define _C                      0x01
#define _DC                     0x02
#define _Z                      0x04
#define _OV                     0x08
#define _N                      0x10

//==============================================================================

extern __at(0x0FD9) __sfr FSR2L;
extern __at(0x0FDA) __sfr FSR2H;
extern __at(0x0FDB) __sfr PLUSW2;
extern __at(0x0FDC) __sfr PREINC2;
extern __at(0x0FDD) __sfr POSTDEC2;
extern __at(0x0FDE) __sfr POSTINC2;
extern __at(0x0FDF) __sfr INDF2;
extern __at(0x0FE0) __sfr BSR;
extern __at(0x0FE1) __sfr FSR1L;
extern __at(0x0FE2) __sfr FSR1H;
extern __at(0x0FE3) __sfr PLUSW1;
extern __at(0x0FE4) __sfr PREINC1;
extern __at(0x0FE5) __sfr POSTDEC1;
extern __at(0x0FE6) __sfr POSTINC1;
extern __at(0x0FE7) __sfr INDF1;
extern __at(0x0FE8) __sfr WREG;
extern __at(0x0FE9) __sfr FSR0L;
extern __at(0x0FEA) __sfr FSR0H;
extern __at(0x0FEB) __sfr PLUSW0;
extern __at(0x0FEC) __sfr PREINC0;
extern __at(0x0FED) __sfr POSTDEC0;
extern __at(0x0FEE) __sfr POSTINC0;
extern __at(0x0FEF) __sfr INDF0;

//==============================================================================
//        INTCON3 Bits

extern __at(0x0FF0) __sfr INTCON3;

typedef union
  {
  struct
    {
    unsigned INT1IF             : 1;
    unsigned INT2IF             : 1;
    unsigned INT3IF             : 1;
    unsigned INT1IE             : 1;
    unsigned INT2IE             : 1;
    unsigned INT3IE             : 1;
    unsigned INT1IP             : 1;
    unsigned INT2IP             : 1;
    };

  struct
    {
    unsigned INT1F              : 1;
    unsigned INT2F              : 1;
    unsigned INT3F              : 1;
    unsigned INT1E              : 1;
    unsigned INT2E              : 1;
    unsigned INT3E              : 1;
    unsigned INT1P              : 1;
    unsigned INT2P              : 1;
    };
  } __INTCON3bits_t;

extern __at(0x0FF0) volatile __INTCON3bits_t INTCON3bits;

#define _INT1IF                 0x01
#define _INT1F                  0x01
#define _INT2IF                 0x02
#define _INT2F                  0x02
#define _INT3IF                 0x04
#define _INT3F                  0x04
#define _INT1IE                 0x08
#define _INT1E                  0x08
#define _INT2IE                 0x10
#define _INT2E                  0x10
#define _INT3IE                 0x20
#define _INT3E                  0x20
#define _INT1IP                 0x40
#define _INT1P                  0x40
#define _INT2IP                 0x80
#define _INT2P                  0x80

//==============================================================================


//==============================================================================
//        INTCON2 Bits

extern __at(0x0FF1) __sfr INTCON2;

typedef union
  {
  struct
    {
    unsigned RBIP               : 1;
    unsigned INT3IP             : 1;
    unsigned TMR0IP             : 1;
    unsigned INTEDG3            : 1;
    unsigned INTEDG2            : 1;
    unsigned INTEDG1            : 1;
    unsigned INTEDG0            : 1;
    unsigned NOT_RBPU           : 1;
    };

  struct
    {
    unsigned                    : 1;
    unsigned INT3P              : 1;
    unsigned T0IP               : 1;
    unsigned                    : 1;
    unsigned                    : 1;
    unsigned                    : 1;
    unsigned                    : 1;
    unsigned RBPU               : 1;
    };
  } __INTCON2bits_t;

extern __at(0x0FF1) volatile __INTCON2bits_t INTCON2bits;

#define _RBIP                   0x01
#define _INT3IP                 0x02
#define _INT3P                  0x02
#define _TMR0IP                 0x04
#define _T0IP                   0x04
#define _INTEDG3                0x08
#define _INTEDG2                0x10
#define _INTEDG1                0x20
#define _INTEDG0                0x40
#define _NOT_RBPU               0x80
#define _RBPU                   0x80

//==============================================================================


//==============================================================================
//        INTCON Bits

extern __at(0x0FF2) __sfr INTCON;

typedef union
  {
  struct
    {
    unsigned RBIF               : 1;
    unsigned INT0IF             : 1;
    unsigned TMR0IF             : 1;
    unsigned RBIE               : 1;
    unsigned INT0IE             : 1;
    unsigned TMR0IE             : 1;
    unsigned PEIE_GIEL          : 1;
    unsigned GIE_GIEH           : 1;
    };

  struct
    {
    unsigned                    : 1;
    unsigned INT0F              : 1;
    unsigned T0IF               : 1;
    unsigned                    : 1;
    unsigned INT0E              : 1;
    unsigned T0IE               : 1;
    unsigned PEIE               : 1;
    unsigned GIE                : 1;
    };

  struct
    {
    unsigned                    : 1;
    unsigned                    : 1;
    unsigned                    : 1;
    unsigned                    : 1;
    unsigned                    : 1;
    unsigned                    : 1;
    unsigned GIEL               : 1;
    unsigned GIEH               : 1;
    };
  } __INTCONbits_t;

extern __at(0x0FF2) volatile __INTCONbits_t INTCONbits;

#define _RBIF                   0x01
#define _INT0IF                 0x02
#define _INT0F                  0x02
#define _TMR0IF                 0x04
#define _T0IF                   0x04
#define _RBIE                   0x08
#define _INT0IE                 0x10
#define _INT0E                  0x10
#define _TMR0IE                 0x20
#define _T0IE                   0x20
#define _PEIE_GIEL              0x40
#define _PEIE                   0x40
#define _GIEL                   0x40
#define _GIE_GIEH               0x80
#define _GIE                    0x80
#define _GIEH                   0x80

//==============================================================================

extern __at(0x0FF3) __sfr PROD;
extern __at(0x0FF3) __sfr PRODL;
extern __at(0x0FF4) __sfr PRODH;
extern __at(0x0FF5) __sfr TABLAT;
extern __at(0x0FF6) __sfr TBLPTR;
extern __at(0x0FF6) __sfr TBLPTRL;
extern __at(0x0FF7) __sfr TBLPTRH;
extern __at(0x0FF8) __sfr TBLPTRU;
extern __at(0x0FF9) __sfr PC;
extern __at(0x0FF9) __sfr PCL;
extern __at(0x0FFA) __sfr PCLATH;
extern __at(0x0FFB) __sfr PCLATU;

//==============================================================================
//        STKPTR Bits

extern __at(0x0FFC) __sfr STKPTR;

typedef union
  {
  struct
    {
    unsigned SP0                : 1;
    unsigned SP1                : 1;
    unsigned SP2                : 1;
    unsigned SP3                : 1;
    unsigned SP4                : 1;
    unsigned                    : 1;
    unsigned STKUNF             : 1;
    unsigned STKFUL             : 1;
    };

  struct
    {
    unsigned                    : 1;
    unsigned                    : 1;
    unsigned                    : 1;
    unsigned                    : 1;
    unsigned                    : 1;
    unsigned                    : 1;
    unsigned                    : 1;
    unsigned STKOVF             : 1;
    };

  struct
    {
    unsigned SP                 : 5;
    unsigned                    : 3;
    };
  } __STKPTRbits_t;

extern __at(0x0FFC) volatile __STKPTRbits_t STKPTRbits;

#define _SP0                    0x01
#define _SP1                    0x02
#define _SP2                    0x04
#define _SP3                    0x08
#define _SP4                    0x10
#define _STKUNF                 0x40
#define _STKFUL                 0x80
#define _STKOVF                 0x80

//==============================================================================

extern __at(0x0FFD) __sfr TOS;
extern __at(0x0FFD) __sfr TOSL;
extern __at(0x0FFE) __sfr TOSH;
extern __at(0x0FFF) __sfr TOSU;

//==============================================================================
//
//        Configuration Bits
//
//==============================================================================

#define __CONFIG1L              0x300000
#define __CONFIG1H              0x300001
#define __CONFIG2L              0x300002
#define __CONFIG2H              0x300003
#define __CONFIG3L              0x300004
#define __CONFIG3H              0x300005
#define __CONFIG4L              0x300006
#define __CONFIG5L              0x300008
#define __CONFIG5H              0x300009
#define __CONFIG6L              0x30000A
#define __CONFIG6H              0x30000B
#define __CONFIG7L              0x30000C
#define __CONFIG7H              0x30000D

//----------------------------- CONFIG1L Options -------------------------------

#define _RETEN_OFF_1L           0xFE    // Disabled - Controlled by SRETEN bit.
#define _RETEN_ON_1L            0xFF    // Enabled.
#define _INTOSCSEL_LOW_1L       0xFB    // LF-INTOSC in Low-power mode during Sleep.
#define _INTOSCSEL_HIGH_1L      0xFF    // LF-INTOSC in High-power mode during Sleep.
#define _SOSCSEL_LOW_1L         0xEF    // Low Power SOSC circuit selected.
#define _SOSCSEL_DIG_1L         0xF7    // Digital (SCLKI) mode.
#define _SOSCSEL_HIGH_1L        0xFF    // High Power SOSC circuit selected.
#define _XINST_OFF_1L           0xBF    // Disabled.
#define _XINST_ON_1L            0xFF    // Enabled.

//----------------------------- CONFIG1H Options -------------------------------

#define _FOSC_LP_1H             0xF0    // LP oscillator.
#define _FOSC_XT_1H             0xF1    // XT oscillator.
#define _FOSC_HS2_1H            0xF2    // HS oscillator (High power, 16 MHz - 25 MHz).
#define _FOSC_HS1_1H            0xF3    // HS oscillator (Medium power, 4 MHz - 16 MHz).
#define _FOSC_EC3IO_1H          0xF4    // EC oscillator, CLKOUT function on OSC2 (High power, 16 MHz - 64 MHz).
#define _FOSC_EC3_1H            0xF5    // EC oscillator (High power, 16 MHz - 64 MHz).
#define _FOSC_RC_1H             0xF6    // External RC oscillator, CLKOUT function on OSC2.
#define _FOSC_RCIO_1H           0xF7    // External RC oscillator.
#define _FOSC_INTIO2_1H         0xF8    // Internal RC oscillator.
#define _FOSC_INTIO1_1H         0xF9    // Internal RC oscillator, CLKOUT function on OSC2.
#define _FOSC_EC2IO_1H          0xFA    // EC oscillator, CLKOUT function on OSC2 (Medium power, 160 kHz - 16 MHz).
#define _FOSC_EC2_1H            0xFB    // EC oscillator (Medium power, 160 kHz - 16 MHz).
#define _FOSC_EC1IO_1H          0xFC    // EC oscillator, CLKOUT function on OSC2 (Low power, DC - 160 kHz).
#define _FOSC_EC1_1H            0xFD    // EC oscillator (Low power, DC - 160 kHz).
#define _PLLCFG_OFF_1H          0xEF    // Disabled.
#define _PLLCFG_ON_1H           0xFF    // Enabled.
#define _FCMEN_OFF_1H           0xBF    // Disabled.
#define _FCMEN_ON_1H            0xFF    // Enabled.
#define _IESO_OFF_1H            0x7F    // Disabled.
#define _IESO_ON_1H             0xFF    // Enabled.

//----------------------------- CONFIG2L Options -------------------------------

#define _PWRTEN_ON_2L           0xFE    // Enabled.
#define _PWRTEN_OFF_2L          0xFF    // Disabled.
#define _BOREN_OFF_2L           0xF9    // Disabled in hardware, SBOREN disabled.
#define _BOREN_ON_2L            0xFB    // Controlled with SBOREN bit.
#define _BOREN_NOSLP_2L         0xFD    // Enabled while active, disabled in SLEEP, SBOREN disabled.
#define _BOREN_SBORDIS_2L       0xFF    // Enabled in hardware, SBOREN disabled.
#define _BORV_0_2L              0xE7    // 3.0V.
#define _BORV_1_2L              0xEF    // 2.7V.
#define _BORV_2_2L              0xF7    // 2.0V.
#define _BORV_3_2L              0xFF    // 1.8V.
#define _BORPWR_LOW_2L          0x9F    // BORMV set to low power level.
#define _BORPWR_MEDIUM_2L       0xBF    // BORMV set to medium power level.
#define _BORPWR_HIGH_2L         0xDF    // BORMV set to high power level.
#define _BORPWR_ZPBORMV_2L      0xFF    // ZPBORMV instead of BORMV is selected.

//----------------------------- CONFIG2H Options -------------------------------

#define _WDTEN_OFF_2H           0xFC    // WDT disabled in hardware; SWDTEN bit disabled.
#define _WDTEN_NOSLP_2H         0xFD    // WDT enabled only while device is active and disabled in Sleep mode; SWDTEN bit disabled.
#define _WDTEN_ON_2H            0xFE    // WDT controlled by SWDTEN bit setting.
#define _WDTEN_SWDTDIS_2H       0xFF    // WDT enabled in hardware; SWDTEN bit disabled.
#define _WDTPS_1_2H             0x83    // 1:1.
#define _WDTPS_2_2H             0x87    // 1:2.
#define _WDTPS_4_2H             0x8B    // 1:4.
#define _WDTPS_8_2H             0x8F    // 1:8.
#define _WDTPS_16_2H            0x93    // 1:16.
#define _WDTPS_32_2H            0x97    // 1:32.
#define _WDTPS_64_2H            0x9B    // 1:64.
#define _WDTPS_128_2H           0x9F    // 1:128.
#define _WDTPS_256_2H           0xA3    // 1:256.
#define _WDTPS_512_2H           0xA7    // 1:512.
#define _WDTPS_1024_2H          0xAB    // 1:1024.
#define _WDTPS_2048_2H          0xAF    // 1:2048.
#define _WDTPS_4096_2H          0xB3    // 1:4096.
#define _WDTPS_8192_2H          0xB7    // 1:8192.
#define _WDTPS_16384_2H         0xBB    // 1:16384.
#define _WDTPS_32768_2H         0xBF    // 1:32768.
#define _WDTPS_65536_2H         0xC3    // 1:65536.
#define _WDTPS_131072_2H        0xC7    // 1:131072.
#define _WDTPS_262144_2H        0xCB    // 1:262144.
#define _WDTPS_524288_2H        0xCF    // 1:524288.
#define _WDTPS_1048576_2H       0xFF    // 1:1048576.

//----------------------------- CONFIG3L Options -------------------------------

#define _RTCOSC_INTOSCREF_3L    0xFE    // RTCC uses INTRC.
#define _RTCOSC_SOSCREF_3L      0xFF    // RTCC uses SOSC.
#define _EASHFT_OFF_3L          0xF7    // Address shifting disabled.
#define _EASHFT_ON_3L           0xFF    // Address shifting enabled.
#define _ABW_XM20_3L            0xCF    // 20-bit address bus.
#define _ABW_XM16_3L            0xDF    // 16-bit address bus.
#define _ABW_XM12_3L            0xEF    // 12-bit address bus.
#define _ABW_MM_3L              0xFF    // 8-bit address bus.
#define _BW_8_3L                0xBF    // 8-bit external bus mode.
#define _BW_16_3L               0xFF    // 16-bit external bus mode.
#define _WAIT_ON_3L             0x7F    // Enabled.
#define _WAIT_OFF_3L            0xFF    // Disabled.

//----------------------------- CONFIG3H Options -------------------------------

#define _CCP2MX_PORTBE_3H       0xFE    // RE7-Microcontroller Mode/RB3-All other modes.
#define _CCP2MX_PORTC_3H        0xFF    // RC1.
#define _ECCPMX_PORTH_3H        0xFD    // Enhanced CCP1/3 [P1B/P1C/P3B/P3C] muxed with RH7/RH6/RH5/RH4.
#define _ECCPMX_PORTE_3H        0xFF    // Enhanced CCP1/3 [P1B/P1C/P3B/P3C] muxed with RE6/RE5/RE4/RE3.
#define _MSSPMSK_MSK5_3H        0xF7    // 5 bit address masking mode.
#define _MSSPMSK_MSK7_3H        0xFF    // 7 Bit address masking mode.
#define _MCLRE_OFF_3H           0x7F    // MCLR Disabled, RG5 Enabled.
#define _MCLRE_ON_3H            0xFF    // MCLR Enabled, RG5 Disabled.

//----------------------------- CONFIG4L Options -------------------------------

#define _STVREN_OFF_4L          0xFE    // Disabled.
#define _STVREN_ON_4L           0xFF    // Enabled.
#define _BBSIZ_BB1K_4L          0xEF    // 1K word Boot Block size.
#define _BBSIZ_BB2K_4L          0xFF    // 2K word Boot Block size.
#define _DEBUG_ON_4L            0x7F    // Enabled.
#define _DEBUG_OFF_4L           0xFF    // Disabled.

//----------------------------- CONFIG5L Options -------------------------------

#define _CP0_ON_5L              0xFE    // Enabled.
#define _CP0_OFF_5L             0xFF    // Disabled.
#define _CP1_ON_5L              0xFD    // Enabled.
#define _CP1_OFF_5L             0xFF    // Disabled.
#define _CP2_ON_5L              0xFB    // Enabled.
#define _CP2_OFF_5L             0xFF    // Disabled.
#define _CP3_ON_5L              0xF7    // Enabled.
#define _CP3_OFF_5L             0xFF    // Disabled.

//----------------------------- CONFIG5H Options -------------------------------

#define _CPB_ON_5H              0xBF    // Enabled.
#define _CPB_OFF_5H             0xFF    // Disabled.
#define _CPD_ON_5H              0x7F    // Enabled.
#define _CPD_OFF_5H             0xFF    // Disabled.

//----------------------------- CONFIG6L Options -------------------------------

#define _WRT0_ON_6L             0xFE    // Enabled.
#define _WRT0_OFF_6L            0xFF    // Disabled.
#define _WRT1_ON_6L             0xFD    // Enabled.
#define _WRT1_OFF_6L            0xFF    // Disabled.
#define _WRT2_ON_6L             0xFB    // Enabled.
#define _WRT2_OFF_6L            0xFF    // Disabled.
#define _WRT3_ON_6L             0xF7    // Enabled.
#define _WRT3_OFF_6L            0xFF    // Disabled.

//----------------------------- CONFIG6H Options -------------------------------

#define _WRTC_ON_6H             0xDF    // Enabled.
#define _WRTC_OFF_6H            0xFF    // Disabled.
#define _WRTB_ON_6H             0xBF    // Enabled.
#define _WRTB_OFF_6H            0xFF    // Disabled.
#define _WRTD_ON_6H             0x7F    // Enabled.
#define _WRTD_OFF_6H            0xFF    // Disabled.

//----------------------------- CONFIG7L Options -------------------------------

#define _EBRT0_ON_7L            0xFE    // Enabled.
#define _EBRT0_OFF_7L           0xFF    // Disabled.
#define _EBRT1_ON_7L            0xFD    // Enabled.
#define _EBRT1_OFF_7L           0xFF    // Disabled.
#define _EBRT2_ON_7L            0xFB    // Enabled.
#define _EBRT2_OFF_7L           0xFF    // Disabled.
#define _EBRT3_ON_7L            0xF7    // Enabled.
#define _EBRT3_OFF_7L           0xFF    // Disabled.

//----------------------------- CONFIG7H Options -------------------------------

#define _EBRTB_ON_7H            0xBF    // Enabled.
#define _EBRTB_OFF_7H           0xFF    // Disabled.

//==============================================================================

#define __DEVID1                0x3FFFFE
#define __DEVID2                0x3FFFFF

#define __IDLOC0                0x200000
#define __IDLOC1                0x200001
#define __IDLOC2                0x200002
#define __IDLOC3                0x200003
#define __IDLOC4                0x200004
#define __IDLOC5                0x200005
#define __IDLOC6                0x200006
#define __IDLOC7                0x200007

#endif // #ifndef __PIC18F86K22_H__
